/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.testquack.beans.Attachment;
import com.testquack.beans.Attribute;
import com.testquack.beans.EntityPreview;
import com.testquack.beans.Event;
import com.testquack.beans.EventType;
import com.testquack.beans.Filter;
import com.testquack.beans.Issue;
import com.testquack.beans.IssuePriority;
import com.testquack.beans.IssueType;
import com.testquack.beans.Sequencer;
import com.testquack.beans.TestCase;
import com.testquack.beans.TestCaseTree;
import com.testquack.beans.TestcaseFilter;
import com.testquack.beans.TrackerProject;
import com.testquack.dal.CommonRepository;
import com.testquack.dal.TestCasePreviewRepository;
import com.testquack.dal.TestCaseRepository;
import com.testquack.services.AttributeService;
import com.testquack.services.BaseService;
import com.testquack.services.EventService;
import com.testquack.services.SequencerService;
import com.testquack.services.errors.EntityNotFoundException;
import com.testquack.storage.Storage;
import com.testquack.tracker.Tracker;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.greatbit.utils.string.StringUtils;
import ru.greatbit.whoru.auth.Session;

@Service
public class TestCaseService
extends BaseService<TestCase> {
    @Autowired
    private TestCaseRepository repository;
    @Autowired
    private TestCasePreviewRepository testCasePreviewRepository;
    @Autowired
    private SequencerService sequencerService;
    @Autowired
    private AttributeService attributeService;
    @Autowired
    private Storage storage;
    @Autowired
    private Tracker tracker;
    @Autowired
    private EventService eventService;
    private final String UNKNOWN_GROUP = "None";

    @Override
    protected CommonRepository<TestCase> getRepository() {
        return this.repository;
    }

    public TestCaseTree findFilteredTree(Session session, String projectId, TestcaseFilter filter) {
        TestCaseTree head = new TestCaseTree();
        List testCases = this.userCanReadProject(session, projectId) ? this.testCasePreviewRepository.find(this.getCurrOrganizationId(session), projectId, (Filter)filter) : Collections.emptyList();
        head.getTestCases().addAll(testCases.stream().map(TestCase::new).collect(Collectors.toList()));
        this.buildTree(head, new ArrayList<String>(filter.getGroups()));
        return head;
    }

    public TestCaseTree findFilteredTreeFullCase(Session session, String projectId, TestcaseFilter filter) {
        TestCaseTree head = new TestCaseTree();
        List testCases = this.userCanReadProject(session, projectId) ? this.repository.find(this.getCurrOrganizationId(session), projectId, (Filter)filter) : Collections.emptyList();
        head.getTestCases().addAll(testCases);
        this.buildTree(head, new ArrayList<String>(filter.getGroups()));
        return head;
    }

    private TestCaseTree buildTree(TestCaseTree head, List<String> groups) {
        if (groups.isEmpty()) {
            head.setCount(head.getTestCases().size());
            return head;
        }
        String groupId = groups.get(0);
        List nextGroups = groups.stream().skip(1L).collect(Collectors.toList());
        HashMap casesByGroupValues = new HashMap();
        head.getTestCases().forEach(testCase -> {
            Set<String> attrValues = testCase.getAttributes().entrySet().stream().filter(attribute -> groupId.equals(attribute.getKey())).flatMap(attribute -> ((Set)attribute.getValue()).stream()).collect(Collectors.toSet());
            if (attrValues.isEmpty()) {
                this.addToMapOfList(casesByGroupValues, "None", (TestCase)testCase);
            }
            attrValues.forEach(attributeVal -> this.addToMapOfList(casesByGroupValues, (String)attributeVal, (TestCase)testCase));
        });
        casesByGroupValues.entrySet().stream().forEach(entry -> {
            TestCaseTree child = (TestCaseTree)new TestCaseTree().withTestCases((Collection)entry.getValue()).withTitle((String)entry.getKey()).withId(groupId + ":" + (String)entry.getKey());
            this.buildTree(child, nextGroups);
            head.getChildren().add(child);
        });
        head.setCount(head.getTestCases().size());
        head.getTestCases().clear();
        return head;
    }

    private void addToMapOfList(Map<String, List<TestCase>> casesByGroupValues, String attrValue, TestCase testCase) {
        casesByGroupValues.putIfAbsent(attrValue, new ArrayList());
        casesByGroupValues.get(attrValue).add(testCase);
    }

    @Override
    protected void beforeCreate(Session session, String projectId, TestCase entity) {
        TestcaseFilter filter;
        TestCase existingEntity;
        super.beforeCreate(session, projectId, entity);
        if (!org.springframework.util.StringUtils.isEmpty((Object)entity.getAlias()) && (existingEntity = (TestCase)this.findFiltered(session, projectId, (Filter)(filter = (TestcaseFilter)new TestcaseFilter().withField("alias", new Object[]{entity.getAlias()}).withField("deleted", new Object[]{true}).withField("deleted", new Object[]{false}))).stream().findFirst().orElse(null)) != null) {
            entity.mergeFrom((Object)entity, (Object)existingEntity);
            entity.setDeleted(false);
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)entity.getName()) && !org.springframework.util.StringUtils.isEmpty((Object)entity.getImportedName())) {
            entity.setName(entity.getImportedName());
        }
        if (org.springframework.util.StringUtils.isEmpty((Object)entity.getId())) {
            Sequencer sequencer = this.sequencerService.increment(this.getCurrOrganizationId(session), projectId);
            entity.setId(Long.toString(sequencer.getIndex()));
        }
    }

    @Override
    protected void beforeSave(Session session, String projectId, TestCase entity) {
        super.beforeSave(session, projectId, entity);
        this.createMissingAttributes(session, projectId, entity);
    }

    @Override
    protected void beforeUpdate(Session session, String projectId, TestCase existingEntity, TestCase entity) {
        super.beforeUpdate(session, projectId, existingEntity, entity);
        entity.setAttachments(existingEntity.getAttachments());
        if (existingEntity != null) {
            this.eventService.create(session, projectId, new Event().withEventType(EventType.UPDATED.toString()).withTime(System.currentTimeMillis()).withUser(session.getLogin()).withEntityId(existingEntity.getId()).withEntityType(TestCase.class.getSimpleName()));
        }
    }

    @Override
    protected TestCase beforeReturn(Session session, String projectId, TestCase entity) {
        entity = super.beforeReturn(session, projectId, entity);
        entity.getAttachments().forEach(attachment -> {
            attachment.setUrl(null);
            attachment.setStorageType(null);
        });
        return entity;
    }

    public List<TestCase> importTestCases(Session user, String projectId, List<TestCase> testCases) {
        testCases.forEach(testCase -> this.importTestCase(user, projectId, (TestCase)testCase));
        return testCases;
    }

    private void importTestCase(Session user, String projectId, TestCase testCase) {
        TestCase existingTestcase = null;
        try {
            if (!org.springframework.util.StringUtils.isEmpty((Object)testCase.getId())) {
                existingTestcase = (TestCase)this.findOne(user, projectId, testCase.getId());
            }
        }
        catch (EntityNotFoundException e) {
            this.logger.info(String.format("Unable to find testcase to import by id [%s]. Will try by alias [%s]", testCase.getId(), StringUtils.emptyIfNull((String)testCase.getAlias())));
        }
        if (existingTestcase == null && !org.springframework.util.StringUtils.isEmpty((Object)testCase.getAlias())) {
            Filter filter = (Filter)new Filter().withField("alias", new Object[]{testCase.getAlias()}).withLimit(1);
            existingTestcase = this.findFiltered(user, projectId, filter).stream().findFirst().orElse(null);
        }
        if (existingTestcase == null) {
            existingTestcase = testCase;
        } else {
            existingTestcase.mergeFrom((Object)existingTestcase, (Object)testCase);
            existingTestcase.getAttributes().putAll(testCase.getAttributes());
            existingTestcase.getMetaData().putAll(testCase.getMetaData());
        }
        existingTestcase.setDeleted(false);
        this.save(user, projectId, existingTestcase);
    }

    private TestCase createMissingAttributes(Session session, String projectId, TestCase testCase) {
        Filter attributeFilter = new Filter().withIncludedField("id");
        List attributes = this.attributeService.findFiltered(session, projectId, attributeFilter);
        if (attributes.size() == 0) {
            return testCase;
        }
        Set attributeKeys = attributes.stream().map(EntityPreview::getId).collect(Collectors.toSet());
        HashMap newAttributes = new HashMap();
        testCase.getAttributes().forEach((key, value) -> {
            if (!attributeKeys.contains(key)) {
                Attribute newAttribute = this.attributeService.create(session, projectId, new Attribute().withValues((Collection)value).withName(key));
                newAttributes.put(newAttribute.getId(), value);
            } else {
                newAttributes.put(key, value);
            }
        });
        testCase.getAttributes().clear();
        testCase.getAttributes().putAll(newAttributes);
        return testCase;
    }

    public TestCase uploadAttachment(Session userSession, String projectId, String testcaseId, InputStream uploadedInputStream, String fileName, long size) throws IOException {
        Attachment attachment = this.storage.upload(this.getCurrOrganizationId(userSession), projectId, uploadedInputStream, fileName, size);
        return this.update(userSession, projectId, (TestCase)new TestCase().withId(testcaseId).withLastModifiedTime(Long.MAX_VALUE), (originalEntity, newEntity) -> {
            attachment.withId(UUID.randomUUID().toString()).withCreatedBy(userSession.getLogin()).withCreatedTime(System.currentTimeMillis()).withDataSize(size);
            ((TestCase)originalEntity).getAttachments().add(attachment);
            return originalEntity;
        });
    }

    public Attachment getAttachment(Session userSession, String projectId, String testcaseId, String attachmentId) {
        TestCase testCase = (TestCase)this.findOneUnfiltered(userSession, projectId, testcaseId);
        return this.getAttachment(testCase, attachmentId);
    }

    public TestCase deleteAttachment(Session userSession, String projectId, String testcaseId, String attachmentId) throws IOException {
        TestCase testCase = (TestCase)this.findOneUnfiltered(userSession, projectId, testcaseId);
        Attachment attachment = this.getAttachment(testCase, attachmentId);
        this.storage.remove(attachment);
        testCase.getAttachments().remove(attachment);
        return this.update(userSession, projectId, testCase);
    }

    private Attachment getAttachment(TestCase testCase, String attachmentId) {
        return testCase.getAttachments().stream().filter(attachment -> attachment.getId().equals(attachmentId)).findFirst().orElseThrow(EntityNotFoundException::new);
    }

    public InputStream getAttachmentStream(Attachment attachment) throws IOException {
        return this.storage.get(attachment);
    }

    public TestCase createIssue(HttpServletRequest request, Session userSession, String projectId, String testcaseId, Issue issue) throws Exception {
        TestCase testCase = (TestCase)this.findOne(userSession, projectId, testcaseId);
        testCase.getIssues().add(this.tracker.createIssue(request, userSession, issue));
        return this.update(userSession, projectId, testCase);
    }

    public Issue getIssue(HttpServletRequest request, Session userSession, String issueId) throws Exception {
        return this.tracker.getIssue(request, userSession, issueId);
    }

    public TestCase linkIssue(HttpServletRequest request, Session userSession, String projectId, String testcaseId, String issueId) throws Exception {
        TestCase testCase = (TestCase)this.findOne(userSession, projectId, testcaseId);
        if (testCase.getIssues().stream().map(Issue::getId).filter(id -> id.equals(issueId)).count() > 0L) {
            return testCase;
        }
        testCase.getIssues().add(this.tracker.linkIssue(request, userSession, issueId));
        return this.update(userSession, projectId, testCase);
    }

    public TestCase unlinkIssue(HttpServletRequest request, Session userSession, String projectId, String testcaseId, String issueId) {
        TestCase testCase = (TestCase)this.findOne(userSession, projectId, testcaseId);
        List issues = testCase.getIssues().stream().filter(issue -> !issue.getId().equals(issueId)).collect(Collectors.toList());
        testCase.setIssues(issues);
        return this.update(userSession, projectId, testCase);
    }

    public List<Issue> suggestIssue(HttpServletRequest request, Session userSession, String issueProject, String text) throws Exception {
        return this.tracker.suggestIssue(request, userSession, issueProject, text);
    }

    public List<TrackerProject> suggestProjects(HttpServletRequest request, Session userSession, String projectId, String text) throws Exception {
        return this.tracker.suggestProjects(request, userSession, projectId, text);
    }

    public List<TrackerProject> getAllProjects(HttpServletRequest request, Session userSession, String projectId) throws Exception {
        return this.tracker.getAllProjects(request, userSession, projectId);
    }

    public List<IssueType> getIssueTypes(HttpServletRequest request, Session userSession, String issueProjectId) throws Exception {
        return this.tracker.getIssueTypes(request, userSession, issueProjectId);
    }

    public List<IssuePriority> getIssuePriorities(HttpServletRequest request, Session userSession, String issueProjectId) throws Exception {
        return this.tracker.getIssuePriorities(request, userSession, issueProjectId);
    }

    public TestCase cloneTestCase(Session userSession, String projectId, String testcaseId) {
        TestCase originalTestCase = (TestCase)this.findOne(userSession, projectId, testcaseId);
        TestCase testCaseToCreate = this.cleanTestCaseForDuplication(originalTestCase);
        testCaseToCreate.setName("Clone of " + originalTestCase.getName());
        return this.create(userSession, projectId, testCaseToCreate);
    }

    public String exportToCSV(Session session, String projectId, TestcaseFilter filter) {
        List testCases = this.userCanReadProject(session, projectId) ? this.repository.find(this.getCurrOrganizationId(session), projectId, (Filter)filter) : Collections.emptyList();
        testCases.sort(Comparator.comparing(EntityPreview::getId));
        return this.mapTestcasesToCsv(session, projectId, testCases);
    }

    private String mapTestcasesToCsv(Session session, String projectId, List<TestCase> testCases) {
        Map attributesWithNames = this.attributeService.findFiltered(session, projectId, new Filter()).stream().collect(Collectors.toMap(EntityPreview::getId, EntityPreview::getName, (v1, v2) -> v1, LinkedHashMap::new));
        String header = this.buildCsvHeader(attributesWithNames);
        String testcasesCsv = this.buildTestcasesCsv(testCases, attributesWithNames);
        return header + "\n" + testcasesCsv;
    }

    private String buildTestcasesCsv(List<TestCase> testCases, Map<String, String> attributesWithNames) {
        return testCases.stream().map(testCase -> this.buildTestcaseCsv((TestCase)testCase, attributesWithNames)).collect(Collectors.joining("\n"));
    }

    private String buildTestcaseCsv(TestCase testCase, Map<String, String> attributesWithNames) {
        return testCase.getId() + "," + this.wrapCsvLine(testCase.getName()) + "," + this.getTestcaseAttributesCsv(testCase, attributesWithNames);
    }

    private String getTestcaseAttributesCsv(TestCase testCase, Map<String, String> attributesWithNames) {
        return attributesWithNames.keySet().stream().map(attributeKey -> this.getTestcaseAttributeValuesInCSV(testCase, (String)attributeKey)).map(this::wrapCsvLine).collect(Collectors.joining(","));
    }

    private String getTestcaseAttributeValuesInCSV(TestCase testCase, String attributeKey) {
        Set values = testCase.getAttributes().getOrDefault(attributeKey, Collections.emptySet());
        return String.join((CharSequence)",", values);
    }

    private String wrapCsvLine(String csvLine) {
        return "\"" + csvLine + "\"";
    }

    private String buildCsvHeader(Map<String, String> attributesWithNames) {
        return "Id,Name," + attributesWithNames.values().stream().map(this::wrapCsvLine).collect(Collectors.joining(","));
    }

    private TestCase cleanTestCaseForDuplication(TestCase originalTestCase) {
        TestCase copyTestCase = (TestCase)originalTestCase.copyTo((Object)new TestCase());
        long now = System.currentTimeMillis();
        copyTestCase.setId(null);
        copyTestCase.getAttachments().clear();
        copyTestCase.setCreatedBy(null);
        copyTestCase.setCreatedTime(now);
        copyTestCase.getIssues().clear();
        copyTestCase.setLastModifiedBy(null);
        copyTestCase.setLastModifiedTime(now);
        copyTestCase.getAttributes().putAll(originalTestCase.getAttributes());
        return copyTestCase;
    }
}

