/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.services;

import com.testquack.beans.Filter;
import com.testquack.beans.User;
import com.testquack.dal.CommonRepository;
import com.testquack.dal.OrganizationRepository;
import com.testquack.dal.UserRepository;
import com.testquack.services.BaseService;
import com.testquack.services.errors.EntityAccessDeniedException;
import com.testquack.services.errors.EntityNotFoundException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.greatbit.whoru.auth.Session;

@Service
public class UserService
extends BaseService<User> {
    @Autowired
    private UserRepository repository;
    @Autowired
    private OrganizationRepository organizationRepository;

    @Override
    protected CommonRepository<User> getRepository() {
        return this.repository;
    }

    @Override
    protected boolean userCanRead(Session session, String projectId, User entity) {
        return true;
    }

    @Override
    protected boolean userCanSave(Session session, String projectId, User entity) {
        return this.userCanSave(session, entity.getId());
    }

    protected boolean userCanSave(Session session, String login) {
        return session.isIsAdmin() || login.equals(session.getPerson().getLogin());
    }

    @Override
    protected boolean userCanSave(Session session, String projectId, Collection<User> entities) {
        return session.isIsAdmin();
    }

    @Override
    protected boolean userCanDelete(Session session, String projectId, String id) {
        return this.userCanSave(session, id);
    }

    @Override
    protected boolean userCanCreate(Session session, String projectId, User entity) {
        return session.isIsAdmin();
    }

    @Override
    protected boolean userCanUpdate(Session session, String projectId, User entity) {
        return this.userCanSave(session, entity.getId());
    }

    @Override
    public User findOne(Session session, String projectId, String id) {
        return this.cleanUserSesitiveData((User)super.findOne(session, projectId, id));
    }

    @Override
    protected void beforeCreate(Session session, String projectId, User user) {
        super.beforeCreate(session, projectId, user);
        if (this.exists(session, projectId, user.getLogin())) {
            throw new RuntimeException(String.format("User with login %s already exists", user.getLogin()));
        }
        user.setLogin(user.getLogin().trim());
        user.setId(user.getLogin());
        user.setPassword(UserService.encryptPassword(user.getPassword(), user.getLogin()));
        user.setPasswordChangeRequired(true);
    }

    @Override
    protected boolean validateEntity(User ent) {
        return !StringUtils.isEmpty((CharSequence)ent.getLogin());
    }

    public static String encryptPassword(String password, String salt) {
        try {
            return ru.greatbit.utils.string.StringUtils.getMd5String((String)(password + salt));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public void changePassword(Session session, String login, String oldPassword, String newPassword) {
        if (!this.userCanSave(session, login)) {
            throw new EntityAccessDeniedException(String.format("User %s doesn't have permissions to modify %s account", session.getPerson().getLogin(), login));
        }
        User user = this.findOne(this.getCurrOrganizationId(session), new Filter().withField("login", new Object[]{login}));
        user.setPassword(UserService.encryptPassword(newPassword, user.getLogin()));
        user.setPasswordChangeRequired(false);
        this.save(session, null, user);
    }

    public Session changeOrganization(Session session, String organizationId) {
        if (!this.isUserInOrganization(session, organizationId)) {
            throw new EntityNotFoundException("Organization " + organizationId + " not found");
        }
        session.getMetainfo().put("currentOrganization", organizationId);
        return session;
    }

    public User findOne(String organizationId, Filter filter) {
        return (User)this.repository.find(organizationId, null, filter).stream().findFirst().orElseThrow(EntityNotFoundException::new);
    }

    public List<User> findAll() {
        return StreamSupport.stream(this.repository.findAll().spliterator(), false).collect(Collectors.toList());
    }

    public List<User> suggestUsers(String organizationId, String literal) {
        return this.repository.suggestUsers(organizationId, literal);
    }

    private User cleanUserSesitiveData(User user) {
        return user.withPassword(null).withToken(null);
    }
}

