/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.storage;

import com.mongodb.BasicDBObject;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.GridFSBuckets;
import com.mongodb.client.gridfs.model.GridFSFile;
import com.testquack.beans.Attachment;
import com.testquack.storage.Storage;
import java.io.IOException;
import java.io.InputStream;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsTemplate;

public class MongoStorage
implements Storage {
    @Autowired
    private GridFsTemplate gridOperations;
    @Autowired
    private MongoDatabaseFactory mongoDbFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment upload(String organizationId, String projectId, InputStream uploadedInputStream, String fileName, long size) throws IOException {
        BasicDBObject metaData = new BasicDBObject();
        metaData.put("name", (Object)fileName);
        try {
            ObjectId result = this.gridOperations.store(uploadedInputStream, fileName, "application/text", (Object)metaData);
            Attachment attachment = new Attachment().withUrl(result.toString()).withDataSize(size).withTitle(fileName);
            return attachment;
        }
        finally {
            if (uploadedInputStream != null) {
                uploadedInputStream.close();
            }
        }
    }

    public void remove(Attachment attachment) throws IOException {
        this.gridOperations.delete(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(attachment.getUrl()))));
    }

    public InputStream get(Attachment attachment) throws IOException {
        GridFSFile file = this.gridOperations.findOne(new Query().addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)new ObjectId(attachment.getUrl()))));
        if (file == null) {
            throw new RuntimeException(String.format("File with id %s not found", attachment.getId()));
        }
        return new GridFsResource(file, (InputStream)this.getGridFs().openDownloadStream(file.getObjectId())).getInputStream();
    }

    private GridFSBucket getGridFs() {
        MongoDatabase db = this.mongoDbFactory.getMongoDatabase();
        return GridFSBuckets.create((MongoDatabase)db);
    }
}

