/*
 * Decompiled with CFR 0.152.
 */
package testzeus.base;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.function.Function;
import net.minidev.json.JSONArray;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;
import testzeus.base.GetSFApps;
import testzeus.base.HTTPClientWrapper;
import testzeus.base.PageBase;

public class SFPageBase
extends PageBase {
    protected static String uiapi_record_json;
    private static ArrayList<String> listoflabels;
    protected static HashMap<String, String> labelandtype;

    public SFPageBase(WebDriver driver) {
        super(driver);
    }

    public void waitForSFPagetoLoad() throws InterruptedException {
        Thread.sleep(3000L);
        try {
            WebDriverWait wait1 = new WebDriverWait(driver, 50L);
            ExpectedCondition<Boolean> jsLoad = new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver driver) {
                    return ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).toString().equals("complete");
                }
            };
            ExpectedCondition<Boolean> aurascriptLoad = new ExpectedCondition<Boolean>(){

                public Boolean apply(WebDriver driver) {
                    String WAIT_FOR_AURA_SCRIPT = "return (typeof $A !== 'undefined' && $A && $A.metricsService.getCurrentPageTransaction().config.context.ept > 0)";
                    String EPT_COUNTER_SCRIPT = "return ($A.metricsService.getCurrentPageTransaction().config.context.ept)";
                    Boolean result = (Boolean)((JavascriptExecutor)driver).executeScript(WAIT_FOR_AURA_SCRIPT, new Object[0]);
                    if (result.equals(true)) {
                        System.out.println("Experienced Page Load time in milliseconds on the current page is : " + ((JavascriptExecutor)driver).executeScript(EPT_COUNTER_SCRIPT, new Object[0]));
                        return true;
                    }
                    return false;
                }
            };
            if (((Boolean)wait1.until((Function)jsLoad)).booleanValue() && ((Boolean)wait1.until((Function)aurascriptLoad)).booleanValue()) {
                System.out.println("Page load complete");
            } else {
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            System.out.println("Exception happened in waiting for page to load , so sleeping for 5 seconds");
            System.out.println("Exception is " + e.getMessage());
            Thread.sleep(5000L);
        }
    }

    public static void uiApiHitter(String recordID) {
        uiapi_record_json = HTTPClientWrapper.runGetRequest("/ui-api/record-ui/" + recordID + "?formFactor=Large&modes=View,Edit").toString();
        System.out.println(uiapi_record_json);
    }

    public static void sectionGetter() throws Exception {
        String apipath = "$..objectApiName";
        String sobjecttype = JsonPath.read((String)uiapi_record_json, (String)apipath, (Predicate[])new Predicate[0]).toString();
        String sectionspath = "$.layouts." + sobjecttype + "..sections";
        JSONArray sectionsparent = (JSONArray)JsonPath.read((String)uiapi_record_json, (String)sectionspath, (Predicate[])new Predicate[0]);
        JSONArray sectionsarray = (JSONArray)sectionsparent.get(0);
        System.out.println("Count of Sections is : " + sectionsarray.size());
    }

    public static void labelGetter() throws Exception {
        String labelpath = "$..[?(@.editableForUpdate == true)].layoutComponents..label";
        JSONArray listofduplicatelabels = (JSONArray)JsonPath.read((String)uiapi_record_json, (String)labelpath, (Predicate[])new Predicate[0]);
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        for (int i = 0; i < listofduplicatelabels.size(); ++i) {
            labels.add((String)listofduplicatelabels.get(i));
        }
        listoflabels = new ArrayList();
        listoflabels.addAll(labels);
        System.out.println("Labels are " + labels);
    }

    public static void dataTypeGetter() throws Exception {
        labelandtype = new HashMap();
        for (int i = 0; i < listoflabels.size(); ++i) {
            String label = listoflabels.get(i);
            String typepath = "$..[?(@.label =='" + label + "')].dataType";
            String datatype = JsonPath.read((String)uiapi_record_json, (String)typepath, (Predicate[])new Predicate[0]).toString();
            labelandtype.put(label, datatype);
        }
        labelandtype.entrySet().forEach(entry -> System.out.println("Label and types are : " + (String)entry.getKey() + " " + (String)entry.getValue()));
    }

    public void uiApiParser(String recordid) throws Exception {
        SFPageBase.uiApiHitter(recordid);
        SFPageBase.sectionGetter();
        SFPageBase.labelGetter();
        SFPageBase.dataTypeGetter();
    }

    public void formValueFiller(String label, String targetvalue) throws Exception {
        String type;
        switch (type = labelandtype.get(label)) {
            case "[\"String\"]": 
            case "[\"Url\"]": 
            case "[\"Int\"]": 
            case "[\"Phone\"]": 
            case "[\"Currency\"]": 
            case "[\"Double\"]": 
            case "[\"Date\"]": 
            case "[\"Boolean\"]": {
                Thread.sleep(5000L);
                WebElement we = driver.findElement(By.ByName.xpath((String)("//input[@id=string(//label[text()='" + label + "']/@for)]")));
                we.sendKeys(new CharSequence[]{targetvalue});
                System.out.println("Sent values as " + targetvalue);
                break;
            }
            case "[\"TextArea\"]": {
                WebElement we = driver.findElement(By.ByName.xpath((String)("//textarea[@id=string(//label[text()='" + label + "']/@for)]")));
                we.sendKeys(new CharSequence[]{targetvalue});
                break;
            }
            case "[\"Picklist\"]": {
                WebElement we = driver.findElement(By.ByName.xpath((String)("//button[@id=string(//label[text()='" + label + "']/@for)]")));
                we.sendKeys(new CharSequence[]{targetvalue});
                Thread.sleep(2000L);
                we.sendKeys(new CharSequence[]{Keys.ENTER});
                break;
            }
            case "[\"Reference\"]": {
                WebElement we = driver.findElement(By.ByName.xpath((String)("//input[@id=string(//label[text()='" + label + "']/@for)]")));
                we.sendKeys(new CharSequence[]{Keys.ARROW_DOWN});
                Thread.sleep(2000L);
                we.sendKeys(new CharSequence[]{Keys.ENTER});
            }
        }
    }

    public static void verifyRequiredFields(String testdatajson, String objname) {
        String valuename = objname + "Name";
        String isrequiredexpected = SFPageBase.readJsonFile(testdatajson, "$." + valuename + ".isRequired");
        String objjson = HTTPClientWrapper.runGetRequest("/sobjects/" + objname + "/describe/layouts/").toString();
        String jsonpath = "$..[?(@.label==\"Account Name\")]..required";
        String isrequiredactual = JsonPath.read((String)objjson, (String)jsonpath, (Predicate[])new Predicate[0]).toString();
        System.out.print("Validating that the object contains the right mandatory fields");
        if (isrequiredactual.contains(isrequiredexpected)) {
            System.out.println("THIS IS A TEST-------------------------------------SHOULD BE REPLACED BY TESTNG/JUNIT ASSERTS");
            System.out.println("Required fields verified correctly");
            System.out.println("--------------------------------------------------------------------------");
        } else {
            System.out.println("THIS IS A TEST-------------------------------------SHOULD BE REPLACED BY TESTNG/JUNIT ASSERTS");
            System.out.println("Required fields couldnt be verified correctly");
            System.out.println("--------------------------------------------------------------------------");
        }
    }

    public void globalSearch(String searchterm) {
    }

    public String getURL(String appname) {
        GetSFApps getSfApps = new GetSFApps();
        return getSfApps.getAppNavURL(appname);
    }

    public void appLauncher(String appname) throws InterruptedException {
        String accountappurl = this.getURL(appname);
        System.out.println("account URL is" + accountappurl);
        String cleanurl = accountappurl.replace("[\"", "").replace("\"]", "");
        System.out.println("Navigating to App URL as : " + cleanurl);
        this.openHomepage(cleanurl + "?eptVisible=1");
        this.waitForSFPagetoLoad();
    }
}

