/*
 * Decompiled with CFR 0.152.
 */
package tethys.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import tethys.commons.Token;
import tethys.jackson.JacksonTokenIterator$;
import tethys.readers.tokens.BaseTokenIterator;
import tethys.readers.tokens.TokenIterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class JacksonTokenIterator
implements BaseTokenIterator {
    private final JsonParser jsonParser;
    private Token token;

    public static TokenIterator fromFreshParser(JsonParser jsonParser) {
        return JacksonTokenIterator$.MODULE$.fromFreshParser(jsonParser);
    }

    public JacksonTokenIterator(JsonParser jsonParser) {
        this.jsonParser = jsonParser;
        this.token = this.fromId(jsonParser.currentTokenId());
    }

    public Token currentToken() {
        return this.token;
    }

    public Token nextToken() {
        JsonToken t = this.jsonParser.nextToken();
        this.token = t == null ? Token.Empty$.MODULE$ : this.fromId(t.id());
        return this.token;
    }

    public String fieldName() {
        return this.jsonParser.getCurrentName();
    }

    public String string() {
        return this.jsonParser.getValueAsString();
    }

    public Number number() {
        return this.jsonParser.getNumberValue();
    }

    public byte byte() {
        return this.jsonParser.getByteValue();
    }

    public short short() {
        return this.jsonParser.getShortValue();
    }

    public int int() {
        return this.jsonParser.getIntValue();
    }

    public long long() {
        return this.jsonParser.getLongValue();
    }

    public float float() {
        return this.jsonParser.getFloatValue();
    }

    public double double() {
        return this.jsonParser.getDoubleValue();
    }

    public boolean boolean() {
        return this.jsonParser.getBooleanValue();
    }

    private Token fromId(int tokenId) {
        Token.ObjectStartToken$ objectStartToken$;
        int n = tokenId;
        switch (n) {
            case 1: {
                objectStartToken$ = Token.ObjectStartToken$.MODULE$;
                break;
            }
            case 2: {
                objectStartToken$ = Token.ObjectEndToken$.MODULE$;
                break;
            }
            case 3: {
                objectStartToken$ = Token.ArrayStartToken$.MODULE$;
                break;
            }
            case 4: {
                objectStartToken$ = Token.ArrayEndToken$.MODULE$;
                break;
            }
            case 5: {
                objectStartToken$ = Token.FieldNameToken$.MODULE$;
                break;
            }
            case 6: {
                objectStartToken$ = Token.StringValueToken$.MODULE$;
                break;
            }
            case 7: {
                objectStartToken$ = Token.NumberValueToken$.MODULE$;
                break;
            }
            case 8: {
                objectStartToken$ = Token.NumberValueToken$.MODULE$;
                break;
            }
            case 9: {
                objectStartToken$ = Token.BooleanValueToken$.MODULE$;
                break;
            }
            case 10: {
                objectStartToken$ = Token.BooleanValueToken$.MODULE$;
                break;
            }
            case 11: {
                objectStartToken$ = Token.NullValueToken$.MODULE$;
                break;
            }
            default: {
                objectStartToken$ = Token.Empty$.MODULE$;
                break;
            }
        }
        return (Token)objectStartToken$;
    }
}

