/*
 * Decompiled with CFR 0.152.
 */
package com.thedeanda.lorem;

import com.thedeanda.lorem.Lorem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LoremIpsum
implements Lorem {
    private static LoremIpsum instance;
    private List<String> words = new ArrayList<String>();
    private Random random = null;
    private List<String> maleNames;
    private List<String> femaleNames;
    private List<String> surnames;
    private List<String> firstNames;
    private List<String> stateAbbr;
    private List<String> stateFull;
    private List<String> cities;
    private List<String> countries;
    private String[] URL_HOSTS = new String[]{"https://www.google.com/#q=%s", "http://www.bing.com/search?q=%s", "https://search.yahoo.com/search?p=%s", "https://duckduckgo.com/?q=%s"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoremIpsum getInstance() {
        if (instance != null) return instance;
        Class<LoremIpsum> clazz = LoremIpsum.class;
        synchronized (LoremIpsum.class) {
            if (instance != null) return instance;
            instance = new LoremIpsum(new Random());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public LoremIpsum() {
        this(new Random());
    }

    public LoremIpsum(Long seed) {
        this(seed == null ? new Random() : new Random(seed));
    }

    public LoremIpsum(Random random) {
        this.random = random;
        this.words = this.readLines("lorem.txt");
        this.maleNames = this.readLines("male_names.txt");
        this.femaleNames = this.readLines("female_names.txt");
        this.surnames = this.readLines("surnames.txt");
        this.firstNames = new ArrayList<String>();
        this.firstNames.addAll(this.maleNames);
        this.firstNames.addAll(this.femaleNames);
        this.cities = this.readLines("cities.txt");
        this.stateAbbr = this.readLines("state_abbr.txt");
        this.stateFull = this.readLines("state_full.txt");
        this.countries = this.readLines("countries.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> readLines(String file) {
        ArrayList<String> ret = new ArrayList<String>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(file), "UTF-8"));
            while ((line = br.readLine()) != null) {
                ret.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ret;
    }

    @Override
    public String getCity() {
        return this.getRandom(this.cities);
    }

    @Override
    public String getCountry() {
        return this.getRandom(this.countries);
    }

    @Override
    public String getEmail() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFirstName().toLowerCase());
        sb.append(".");
        sb.append(this.getLastName().toLowerCase());
        sb.append("@example.com");
        return sb.toString().replace(' ', '.');
    }

    @Override
    public String getFirstName() {
        return this.getRandom(this.firstNames);
    }

    @Override
    public String getFirstNameMale() {
        return this.getRandom(this.maleNames);
    }

    @Override
    public String getFirstNameFemale() {
        return this.getRandom(this.femaleNames);
    }

    @Override
    public String getLastName() {
        return this.getRandom(this.surnames);
    }

    @Override
    public String getName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    @Override
    public String getNameMale() {
        return this.getFirstNameMale() + " " + this.getLastName();
    }

    @Override
    public String getNameFemale() {
        return this.getFirstNameFemale() + " " + this.getLastName();
    }

    @Override
    public String getTitle(int count) {
        return this.getWords(count, count, true);
    }

    @Override
    public String getTitle(int min, int max) {
        return this.getWords(min, max, true);
    }

    private int getCount(int min, int max) {
        if (min < 0) {
            min = 0;
        }
        if (max < min) {
            max = min;
        }
        int count = max != min ? this.random.nextInt(max - min) + min : min;
        return count;
    }

    @Override
    public String getHtmlParagraphs(int min, int max) {
        int count = this.getCount(min, max);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("<p>");
            sb.append(this.getParagraphs(1, 1));
            sb.append("</p>");
        }
        return sb.toString().trim();
    }

    @Override
    public String getParagraphs(int min, int max) {
        int count = this.getCount(min, max);
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < count; ++j) {
            int sentences = this.random.nextInt(5) + 2;
            for (int i = 0; i < sentences; ++i) {
                String first = this.getWords(1, 1, false);
                first = first.substring(0, 1).toUpperCase() + first.substring(1);
                sb.append(first);
                sb.append(this.getWords(2, 20, false));
                sb.append(".  ");
            }
            sb.append("\n");
        }
        return sb.toString().trim();
    }

    @Override
    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        int hostId = this.random.nextInt(this.URL_HOSTS.length);
        String host = String.format(this.URL_HOSTS[hostId], this.getWords(1));
        sb.append(host);
        return sb.toString();
    }

    private String getWords(int min, int max, boolean title) {
        int count = this.getCount(min, max);
        return this.getWords(count, title);
    }

    @Override
    public String getWords(int count) {
        return this.getWords(count, count, false);
    }

    @Override
    public String getWords(int min, int max) {
        return this.getWords(min, max, false);
    }

    private String getWords(int count, boolean title) {
        StringBuilder sb = new StringBuilder();
        int size = this.words.size();
        for (int wordCount = 0; wordCount < count; ++wordCount) {
            String word = this.words.get(this.random.nextInt(size));
            if (title && (wordCount == 0 || word.length() > 3)) {
                word = word.substring(0, 1).toUpperCase() + word.substring(1);
            }
            sb.append(word);
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private String getRandom(List<String> list) {
        int size = list.size();
        return list.get(this.random.nextInt(size));
    }

    @Override
    public String getPhone() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(this.random.nextInt(9) + 1);
        for (i = 0; i < 2; ++i) {
            sb.append(this.random.nextInt(10));
        }
        sb.append(") ");
        sb.append(this.random.nextInt(9) + 1);
        for (i = 0; i < 2; ++i) {
            sb.append(this.random.nextInt(10));
        }
        sb.append("-");
        for (i = 0; i < 4; ++i) {
            sb.append(this.random.nextInt(10));
        }
        return sb.toString();
    }

    @Override
    public String getStateAbbr() {
        return this.getRandom(this.stateAbbr);
    }

    @Override
    public String getStateFull() {
        return this.getRandom(this.stateFull);
    }

    @Override
    public String getZipCode() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 5; ++i) {
            sb.append(this.random.nextInt(10));
        }
        return sb.toString();
    }

    @Override
    public LocalDateTime getPriorDate(Duration maxDurationBeforeNow) {
        LocalDateTime now = LocalDateTime.now();
        long offset = (long)((double)maxDurationBeforeNow.getSeconds() * this.random.nextDouble());
        LocalDateTime result = now.minusSeconds(offset);
        return result;
    }

    @Override
    public LocalDateTime getFutureDate(Duration maxDurationFromNow) {
        LocalDateTime now = LocalDateTime.now();
        long offset = (long)((double)maxDurationFromNow.getSeconds() * this.random.nextDouble());
        LocalDateTime result = now.plusSeconds(offset);
        return result;
    }
}

