/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate;

import com.thegoate.HealthMonitor;
import com.thegoate.Sponge;
import com.thegoate.Veterinarian;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.annotations.GhostProtocol;
import com.thegoate.dsl.Interpreter;
import com.thegoate.logging.volume.Diary;
import com.thegoate.logging.volume.VolumeKnob;
import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.compare.Compare;
import com.thegoate.utils.togoate.ToGoate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class Goate
implements HealthMonitor,
Diary {
    public static final String GOATE_VARIABLE_PREFIX = "_goate_(%$#)_";
    volatile Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    volatile Map<String, Object> ghosted = new ConcurrentHashMap<String, Object>();
    public static volatile List<String> ghosts = null;
    Interpreter dictionary;
    boolean increment = true;
    public static volatile int innerGoate = 0;
    private Object health = null;
    private Object keySet = null;
    private volatile String entry = "";
    private volatile boolean stale;

    public Goate() {
        this.init();
    }

    public Goate(Map<String, ?> initialData) {
        this.init();
        this.putMap(initialData);
    }

    protected void init() {
        this.dictionary = new Interpreter(this);
        if (ghosts == null) {
            ghosts = Collections.synchronizedList(new ArrayList());
            this.findGhosts();
        }
    }

    private void findGhosts() {
        AnnotationFactory af = new AnnotationFactory().annotatedWith(GhostProtocol.class).buildDirectory();
        Map<String, Class> directory = AnnotationFactory.directory.get(GhostProtocol.class.getCanonicalName());
        for (Map.Entry<String, Class> entry : directory.entrySet()) {
            Class thGhost = entry.getValue();
            GhostProtocol gp = thGhost.getAnnotation(GhostProtocol.class);
            ghosts.addAll(Arrays.asList(gp.ghosts()));
        }
    }

    public Goate autoIncrement(boolean increment) {
        this.increment = increment;
        return this;
    }

    public int size() {
        int size = 0;
        if (this.data != null) {
            size = this.data.size();
        }
        return size;
    }

    public Map<String, Object> data() {
        ConcurrentHashMap<String, Object> mapped = new ConcurrentHashMap<String, Object>();
        for (String key : this.keys()) {
            mapped.put(key, this.get(key));
        }
        this.stale = true;
        return mapped;
    }

    public Set<String> keys() {
        return new TreeSet<String>(this.data.keySet());
    }

    public String[] keysArray() {
        String[] keys = new String[this.data.keySet().size()];
        int i = 0;
        Iterator<String> iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            keys[i] = key = iterator.next();
            ++i;
        }
        return keys;
    }

    public Goate putMap(Map<?, ?> map) {
        if (map != null) {
            map.entrySet().parallelStream().forEach(e -> this.put("" + e.getKey(), e.getValue()));
        }
        return this;
    }

    public Goate put(String key, Object value) {
        if (this.data == null) {
            this.data = new ConcurrentHashMap<String, Object>();
        }
        if (ghosts != null && ghosts.contains(key)) {
            this.ghosted.put(key, value == null ? "null::" : value);
            return this;
        }
        if (key.contains("##")) {
            key = this.buildKey(key);
        }
        this.data.put(key, value == null ? "null::" : value);
        this.stale = true;
        return this;
    }

    public boolean filterOnKey(String key) {
        return key.contains("##");
    }

    public String buildKey(String key) {
        String fullKey = key;
        if (this.increment) {
            while (fullKey.contains("##")) {
                Goate billy = this.filter(fullKey.substring(0, fullKey.indexOf("##")) + "[0-9]+");
                fullKey = fullKey.replaceFirst("##", "" + billy.size());
            }
        } else {
            fullKey = key.replace("##", "" + System.nanoTime());
        }
        return fullKey;
    }

    public Object getStrict(String key) {
        return this.get(key, null, false);
    }

    public Object getStrict(String key, Object def) {
        return this.get(key, def, false);
    }

    public Object get(int index) {
        Iterator<String> keys = this.data.keySet().iterator();
        String key = "";
        while (index >= 0) {
            key = keys.next();
            --index;
        }
        return this.data.get(key);
    }

    public Object get(String key) {
        return this.get(key, null, true);
    }

    public Object get(String key, Object def) {
        return this.get(key, def, true);
    }

    public Object get(String key, Object def, boolean dsl) {
        return this.get(key, def, dsl, Object.class);
    }

    public <T> T get(String key, Object def, Class<T> type) {
        return this.get(key, def, true, type);
    }

    public <T> T get(String key, Object def, boolean dsl, Class<T> type) {
        Object value = System.getProperty(key);
        if (this.filterOnKey(key)) {
            value = this.filter(key.replace("##", "[0-9]*"));
        } else {
            if (value == null) {
                if (key.equals("username")) {
                    value = this.data.get(key);
                }
                if (value == null && (value = System.getenv(key)) == null) {
                    if (ghosts.contains(key)) {
                        if (this.ghosted.containsKey(key)) {
                            value = this.ghosted.get(key);
                        } else if (def != null) {
                            this.ghosted.put(key, def);
                            value = def;
                        }
                    } else if (this.data.containsKey(key)) {
                        value = this.data.get(key);
                    } else if (def != null) {
                        this.data.put(key, def);
                        this.stale = true;
                        value = def;
                    }
                }
            }
            if (value == null && !this.data.containsKey(key) && !this.ghosted.containsKey(key)) {
                value = def;
            }
            if (value != null && dsl) {
                value = this.processDSL(key, value);
            }
        }
        return new GoateReflection().isPrimitive(type) ? this.doCastPrimitive(value, type) : type.cast(value);
    }

    public <T> T doCastPrimitive(Object value, Class<T> type) {
        GoateReflection gr = new GoateReflection();
        if (gr.isBooleanType(type) && gr.isBoolean(value)) {
            value = new Boolean("" + value);
        } else if (gr.isByteType(type) && gr.isByte(value)) {
            value = new Byte("" + value);
        } else if (gr.isIntegerType(type) && gr.isInteger(value)) {
            value = new Integer("" + value);
        } else if (gr.isDoubleType(type) && gr.isDouble(value)) {
            value = new Double("" + value);
        } else if (gr.isFloatType(type) && gr.isFloat(value)) {
            value = new Float("" + value);
        } else if (gr.isLongType(type) && gr.isLong(value)) {
            value = new Long("" + value);
        } else if (gr.isCharacterType(type) && gr.isCharacter(value)) {
            value = new Character(("" + value).charAt(0));
        } else if (gr.isShortType(type) && gr.isShort(value)) {
            value = new Short("" + value);
        }
        return type.cast(value);
    }

    public Object processDSL(Object value) {
        return this.processDSL("", value);
    }

    public Object processDSL(String key, Object value) {
        String check;
        if (value != null && (check = (check = "" + value).contains("::") ? check.substring(0, check.indexOf("::")) : null) != null) {
            value = this.dictionary.translate(key, check, value);
        }
        return value;
    }

    public Goate drop(String key) {
        if (ghosts.contains(key)) {
            this.ghosted.remove(key);
        } else {
            this.data.remove(key);
            this.stale = true;
        }
        return this;
    }

    public Goate scrub(String pattern) {
        Goate scrub = this.filter(pattern);
        if (scrub != null) {
            for (String key : scrub.keys()) {
                this.drop(key);
            }
        }
        this.stale = true;
        return this;
    }

    public String findKeyIgnoreCase(String find) {
        String key = find;
        Optional<String> found = this.keys().parallelStream().filter((? super T k) -> k.equalsIgnoreCase(find)).findFirst();
        if (found.isPresent()) {
            key = found.get();
        }
        return key;
    }

    public Goate filter(String pattern) {
        return this.filterStrict(pattern + ".*");
    }

    public Goate filterStrict(String pattern) {
        Goate filtered = new Goate();
        StringBuilder keyList = new StringBuilder();
        if (this.data != null) {
            for (String key : this.keys()) {
                if (!key.matches(pattern)) continue;
                filtered.put(key, this.getStrict(key));
            }
        }
        return filtered;
    }

    public Goate filterExclude(String pattern) {
        Goate filtered = new Goate();
        if (this.data != null) {
            for (String key : this.keys()) {
                if (key.matches(pattern + ".*")) continue;
                filtered.put(key, this.getStrict(key));
            }
        }
        return filtered;
    }

    public Goate filterByValue(Object value) {
        Goate filtered = new Goate();
        if (this.data != null) {
            for (String key : this.keys()) {
                if (!new Compare(this.get(key)).using("==").to(value).evaluate()) continue;
                filtered.put(key, this.get(key));
            }
        }
        return filtered;
    }

    public Goate filterExcludeByValue(Object value) {
        Goate filtered = new Goate();
        if (this.data != null) {
            for (String key : this.keys()) {
                if (!new Compare(this.get(key)).using("!=").to(value).evaluate()) continue;
                filtered.put(key, this.get(key));
            }
        }
        return filtered;
    }

    public Goate scrubKeys(String pattern) {
        return this.scrubKeys(pattern, "");
    }

    public Goate scrubKeys(String pattern, String sponge) {
        return this.scrubSubKeys(".*", pattern, sponge);
    }

    public Goate scrubKeys(String pattern, Sponge sponge) {
        return this.scrubSubKeys(".*", pattern, sponge);
    }

    public Goate scrubSubKeys(String pattern, String subkey, final String sponge) {
        return this.scrubSubKeys(pattern, subkey, new Sponge(){

            @Override
            public String soap(String dirty) {
                return sponge;
            }
        });
    }

    public Goate scrubSubKeys(String pattern, String subkey, Sponge sponge) {
        ArrayList<String> scrubbed = new ArrayList<String>();
        ArrayList<String> not_scrubbed = new ArrayList<String>();
        if (this.data != null) {
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                if (!entry.getKey().matches(pattern)) continue;
                scrubbed.add(entry.getKey());
                String soap = subkey == null ? entry.getKey().replaceFirst(pattern, sponge.soap(entry.getKey())) : entry.getKey().replaceFirst(subkey, sponge.soap(entry.getKey()));
                this.put(soap, entry.getValue());
                not_scrubbed.add(soap);
            }
            scrubbed.parallelStream().filter((? super T scrub) -> !not_scrubbed.contains(scrub)).collect(Collectors.toList()).parallelStream().forEach(scrub -> this.drop((String)scrub));
        }
        this.stale = true;
        return this;
    }

    public Goate filterAndSplitKeyValuePairs(String filter) {
        return this.filterAndSplitKeyValuePairs(filter, ":=");
    }

    public Goate filterAndSplitKeyValuePairs(String filter, String split) {
        Goate filtered = new Goate();
        if (this.data != null) {
            Goate info = this.filter(filter);
            for (String key : info.keys()) {
                Object strictDef = info.getStrict(key);
                String def = "" + (strictDef == null ? "" : strictDef);
                if (!def.contains(split)) {
                    def = "" + this.processDSL(def);
                }
                if (!def.contains(split)) continue;
                String k = def.substring(0, def.indexOf(split));
                String v = def.substring(def.indexOf(split) + split.length());
                filtered.put("" + this.processDSL(k), this.processDSL(v));
            }
        }
        return filtered;
    }

    public Goate merge(Goate merge, boolean replace) {
        if (merge != null) {
            Set<String> myKeys = this.keys();
            for (String key : merge.keys()) {
                if (replace) {
                    this.put(key, merge.getStrict(key));
                    continue;
                }
                if (myKeys.contains(key)) continue;
                this.put(key, merge.getStrict(key));
            }
        }
        this.stale = true;
        return this;
    }

    public String toString() {
        return this.toString("", "");
    }

    public String toString(String prepadding, String postpadding) {
        return this.toString(prepadding, postpadding, true);
    }

    public String toString(String prepadding, String postpadding, boolean newLine) {
        if (this.stale) {
            StringBuilder sb = new StringBuilder();
            if (innerGoate > 0) {
                sb.append("Goate[");
                if (newLine) {
                    sb.append("\n");
                }
            }
            ++innerGoate;
            boolean appendNewLine = false;
            for (String key : this.keys()) {
                if (appendNewLine && newLine) {
                    sb.append("\n");
                } else if (appendNewLine && !newLine) {
                    sb.append("; ");
                }
                appendNewLine = true;
                Object message = this.data.get(key);
                if (key.startsWith("est1885drpepper23")) {
                    message = new Veterinarian((Goate)message);
                    key = key.replace("est1885drpepper23", "");
                }
                sb.append(prepadding).append(key).append(":").append(VolumeKnob.volume(message)).append(postpadding);
            }
            if (--innerGoate > 0) {
                if (newLine) {
                    sb.append("\n");
                }
                sb.append("]");
            }
            this.entry = sb.toString();
        }
        return this.entry;
    }

    public boolean equals(Object check) {
        return this.compare(check) == 0;
    }

    private Goate keySet() {
        return (Goate)this.keySet;
    }

    @Override
    public Goate healthCheck() {
        return (Goate)this.health;
    }

    public String pad(String text, String pad) {
        StringBuilder sb = new StringBuilder();
        sb.append("%_goate_start%");
        Arrays.stream(text.split("\n")).forEach(line -> sb.append(pad).append((String)line).append("\n"));
        return sb.toString().trim().replace("%_goate_start%", "");
    }

    public int compare(Object check) {
        Goate castCheck;
        boolean resetSet = true;
        this.health = new Goate();
        this.keySet = new Goate();
        int result = this.size();
        if (!(check instanceof Goate || (castCheck = new ToGoate(check).convert()) == null || castCheck.size() == 1 && castCheck.keys().contains("_original_"))) {
            check = castCheck;
        }
        if (check instanceof Goate) {
            Goate gCheck = (Goate)check;
            result = 0;
            for (String key : this.keys()) {
                boolean found = false;
                Object o = this.get(key);
                String keyPattern = key.replaceAll("[0-9]+", "[0-9]+").replace(".", "\\.");
                Set<String> keySet = this.keySet().get(keyPattern, null, Set.class);
                if (keySet == null) {
                    keySet = gCheck.filterStrict(keyPattern).keys();
                    this.keySet().put(keyPattern, keySet);
                }
                for (String checkKey : keySet) {
                    if (new Compare(o).to(gCheck.get(checkKey)).using("==").evaluate()) {
                        found = true;
                        break;
                    }
                    this.healthCheck().put("not equal##", checkKey + ": " + o + "!=" + gCheck.get(checkKey));
                }
                if (found) continue;
                ++result;
                this.healthCheck().put("not found##", key + ": " + o);
            }
        }
        if (resetSet) {
            this.keySet = null;
        }
        return result;
    }

    @Override
    public String mostRecentEntry() {
        if (this.stale) {
            this.writeEntry(VolumeKnob.volume(this, false));
        }
        return this.entry;
    }

    @Override
    public void writeEntry(String entry) {
        this.stale = false;
    }
}

