/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.annotations;

import com.thegoate.annotations.IsDefault;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.reflection.GoateReflection;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.atteo.classindex.ClassIndex;

public class AnnotationFactory {
    protected static final BleatBox LOG = BleatFactory.getLogger(AnnotationFactory.class);
    public static volatile Map<String, Map<String, Class>> directory = new ConcurrentHashMap<String, Map<String, Class>>();
    Object id;
    String methodId;
    Constructor constructor = null;
    Object[] constructorArgs = new Object[0];
    Method check = null;
    Class<? extends Annotation> annotation;
    Class<? extends Annotation> methodAnnotation;
    boolean setDefault = false;
    String checkName = null;

    public AnnotationFactory() {
        if (directory == null) {
            directory = new ConcurrentHashMap<String, Map<String, Class>>();
        }
    }

    public AnnotationFactory clear() {
        this.id = null;
        this.methodId = null;
        this.constructorArgs = new Object[0];
        this.constructor = null;
        this.check = null;
        this.annotation = null;
        this.methodAnnotation = null;
        this.setDefault = false;
        return this;
    }

    public AnnotationFactory doDefault() {
        this.setDefault = true;
        return this;
    }

    public AnnotationFactory findByMethod(String id) {
        this.methodId = id;
        return this;
    }

    public AnnotationFactory find(Object id) {
        this.id = id;
        return this;
    }

    public AnnotationFactory buildUsing(Constructor constructor) {
        this.constructor = constructor;
        return this;
    }

    public AnnotationFactory using(String check) {
        if (this.annotation != null) {
            try {
                this.using(this.annotation.getMethod(check, new Class[0]));
            }
            catch (NoSuchMethodException e) {
                LOG.error("could not find the identifying method: " + check);
            }
        }
        this.checkName = check;
        return this;
    }

    public AnnotationFactory using(Method check) {
        this.check = check;
        return this;
    }

    public AnnotationFactory annotatedWith(Class<? extends Annotation> annotation) {
        this.annotation = annotation;
        if (this.checkName != null) {
            this.using(this.checkName);
        }
        return this;
    }

    public Map<String, Class> getDirectory(String dir) {
        return this.getDirectory(dir, null, null);
    }

    public Map<String, Class> getDirectory(String dir, String id, Method identifier) {
        this.buildDirectory();
        Map<String, Class> unfiltered = directory.get(dir);
        ConcurrentHashMap<String, Class> filtered = new ConcurrentHashMap<String, Class>();
        if (id != null && identifier != null) {
            for (String key : unfiltered.keySet()) {
                try {
                    Object theCheck;
                    Class temp = unfiltered.get(key);
                    Annotation service = temp.getAnnotation(this.annotation);
                    if (identifier == null || (theCheck = identifier.invoke((Object)service, new Object[0])) == null || !theCheck.equals(id)) continue;
                    filtered.put(key, temp);
                }
                catch (Exception e) {
                    LOG.error("Problem checking the class: " + e.getMessage(), e);
                }
            }
        }
        return id != null && identifier != null ? filtered : unfiltered;
    }

    public AnnotationFactory methodAnnotatedWith(Class<? extends Annotation> annotation) {
        this.methodAnnotation = annotation;
        return this;
    }

    public AnnotationFactory constructorArgs(Object[] args) {
        this.constructorArgs = args;
        return this;
    }

    public Class lookUp() {
        this.buildDirectory();
        Class c = null;
        LOG.debug("looking for " + this.annotation.getName());
        String theClass = "" + this.id;
        try {
            c = directory.get(this.annotation.getCanonicalName()).get(theClass);
        }
        catch (NullPointerException e) {
            LOG.error("could not get the class: " + theClass + "; " + e.getMessage(), e);
        }
        return c;
    }

    public Object build() throws IllegalAccessException, InstantiationException, InvocationTargetException {
        this.buildDirectory();
        Class c = this.methodId == null ? this.lookUp() : this.lookUpByAnnotatedMethod();
        return this.build(c);
    }

    public synchronized AnnotationFactory buildDirectory() {
        Map<String, Class> listing;
        if (!directory.containsKey(this.annotation.getCanonicalName())) {
            directory.put(this.annotation.getCanonicalName(), new ConcurrentHashMap());
        }
        if ((listing = directory.get(this.annotation.getCanonicalName())).size() == 0) {
            if (LOG != null) {
                LOG.debug("Building Directory " + this.annotation.getCanonicalName(), "the listing was empty, trying to build it.");
            }
            Iterable klasses = ClassIndex.getAnnotated(this.annotation);
            for (Class klass : klasses) {
                String theClass = klass.getCanonicalName();
                if (LOG != null) {
                    LOG.debug("Adding to directory", theClass);
                }
                try {
                    IsDefault def;
                    Class<?> temp = Class.forName(theClass);
                    Annotation service = temp.getAnnotation(this.annotation);
                    String aid = theClass;
                    if (this.check != null) {
                        Object theCheck = this.check.invoke((Object)service, new Object[0]);
                        if (theCheck != null && theCheck.getClass().isArray()) {
                            for (Object aido : (Object[])theCheck) {
                                listing.put("" + aido, Class.forName(theClass));
                            }
                        } else {
                            listing.put("" + theCheck, Class.forName(theClass));
                        }
                    } else {
                        listing.put(temp.getCanonicalName(), Class.forName(theClass));
                    }
                    if (!this.setDefault || (def = temp.getAnnotation(IsDefault.class)) == null) continue;
                    listing.put("default", temp);
                }
                catch (ClassNotFoundException | IllegalAccessException | NullPointerException | InvocationTargetException e) {
                    LOG.error("could not get the class: " + theClass + "; " + e.getMessage(), e);
                }
                catch (NoClassDefFoundError ncdfe) {
                    LOG.error("Build Directory", "This shouldn't have happened, but a class in the list was not found." + ncdfe.getMessage(), ncdfe);
                }
            }
        }
        return this;
    }

    public AnnotationFactory constructor(Constructor constructor) {
        this.constructor = constructor;
        return this;
    }

    public Object build(Class klass) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object o = null;
        if (klass != null) {
            if (this.constructorArgs != null) {
                Object[] ca = this.constructorArgs;
                if (this.constructor == null) {
                    this.constructor = new GoateReflection().findConstructor(klass.getConstructors(), this.constructorArgs);
                    if (this.constructor == null) {
                        this.constructor = new GoateReflection().findConstructor(klass.getConstructors(), new Object[0]);
                        ca = new Object[]{};
                    }
                }
                if (this.constructor != null) {
                    try {
                        o = this.constructor.newInstance(ca);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        LOG.debug("Building Class", "Problem instantiating a new instances: " + e.getMessage(), e);
                        throw e;
                    }
                } else {
                    LOG.info("Building Class", "Could not find the constructor, wil check for a default constructor...");
                }
            } else {
                o = klass.newInstance();
            }
        } else {
            LOG.debug("Building Class", "The class was not specified, definitely could not build it.");
        }
        return o;
    }

    public Class lookUpByAnnotatedMethod() {
        this.buildDirectory();
        LOG.debug("Look Up Annotated Method", "Trying to look up an annotated method: " + this.methodId);
        Class klass = null;
        Map<String, Class> listings = directory.get(this.annotation.getCanonicalName());
        block2: for (String theClass : listings.keySet()) {
            LOG.debug("Checking Class", theClass);
            List<Method> methods = new GoateReflection().getDeclaredMethods(listings.get(theClass));
            LOG.debug("Methods to check (" + methods.size() + ")", methods.toString());
            for (Method m : methods) {
                if (!m.isAnnotationPresent(this.methodAnnotation)) continue;
                for (Method am : this.methodAnnotation.getDeclaredMethods()) {
                    Annotation dam = m.getAnnotation(this.methodAnnotation);
                    try {
                        LOG.debug("Checking Method", am.getName());
                        if (!this.methodId.equals(am.invoke((Object)dam, new Object[0]))) continue;
                        klass = listings.get(theClass);
                        break;
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        LOG.debug("Look Up Annotated Method", "Problem accessing method: " + e.getMessage(), e);
                    }
                }
                if (klass == null) continue;
                continue block2;
            }
        }
        return klass;
    }

    public Method getMethod() {
        this.buildDirectory();
        Map<String, Class> listings = directory.get(this.annotation.getCanonicalName());
        Method method = null;
        block3: for (String theClass : listings.keySet()) {
            List<Method> methods = new GoateReflection().getDeclaredMethods(listings.get(theClass));
            for (Method m : methods) {
                if (!m.isAnnotationPresent(this.methodAnnotation)) continue;
                for (Method am : this.methodAnnotation.getDeclaredMethods()) {
                    Annotation dam = m.getAnnotation(this.methodAnnotation);
                    try {
                        if (!this.methodId.equals(am.invoke((Object)dam, new Object[0]))) continue;
                        method = m;
                        break;
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
                if (method == null) continue;
                continue block3;
            }
        }
        return method;
    }
}

