/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.data;

import com.thegoate.Goate;
import com.thegoate.data.DataLoader;
import com.thegoate.data.TruncateDataLoader;
import java.util.ArrayList;
import java.util.List;

public class DataSeriesLoader
extends TruncateDataLoader {
    protected boolean loadedFirst = false;

    @Override
    public List<Goate> load() {
        ArrayList<Goate> data = new ArrayList<Goate>();
        Goate listOfDLs = this.parameters.filter("data");
        for (String key : listOfDLs.keys()) {
            List<Goate> mergeData = this.getDataToMerge(listOfDLs.get(key, null, DataLoader.class));
            this.generateSeries(data, mergeData);
            this.loadedFirst = true;
        }
        return data;
    }

    public DataSeriesLoader flatten() {
        this.setParameter("flatten", true);
        return this;
    }

    public DataSeriesLoader merge() {
        this.setParameter("flatten", false);
        return this;
    }

    public DataSeriesLoader truncate(boolean truncate) {
        this.setParameter("truncate", truncate);
        return this;
    }

    public DataSeriesLoader source(DataLoader dl) {
        this.setParameter("data##", dl);
        return this;
    }

    protected void generateSeries(List<Goate> dataList, List<Goate> dataToMerge) {
        if (((Boolean)this.parameters.get("flatten", true)).booleanValue()) {
            this.flattenSeries(dataList, dataToMerge);
        } else {
            this.mergeData(dataList, dataToMerge);
        }
    }

    protected void flattenSeries(List<Goate> dataList, List<Goate> dataToMerge) {
        if (dataList.size() == 0) {
            dataList.add(new Goate());
        }
        Goate data = dataList.get(0);
        for (Goate dtm : dataToMerge) {
            this.seriesData(data, dtm);
        }
    }

    protected Goate seriesData(Goate data, Goate dtm) {
        for (String key : dtm.keys()) {
            data.put(key + "##", dtm.get(key));
        }
        return data;
    }

    protected List<Goate> getDataToMerge(DataLoader dl) {
        return dl != null ? dl.load() : null;
    }

    protected void mergeData(List<Goate> data, List<Goate> dataToMerge) {
        if (dataToMerge != null) {
            for (int i = 0; i < dataToMerge.size(); ++i) {
                if (i < data.size()) {
                    this.seriesData(data.get(i), dataToMerge.get(i));
                    continue;
                }
                if (!("" + this.parameters.get("truncate", false)).equalsIgnoreCase("false") && this.loadedFirst) continue;
                data.add(this.seriesData(new Goate(), dataToMerge.get(i)));
            }
        }
        this.truncate(data, dataToMerge);
    }
}

