/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.data;

import com.thegoate.Goate;
import com.thegoate.data.DataLoader;
import com.thegoate.utils.GoateUtils;
import com.thegoate.utils.get.GetFileAsString;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class PropertyFileDL
extends DataLoader {
    @Override
    public List<Goate> load() {
        ArrayList<Goate> data = new ArrayList<Goate>();
        Goate props = this.loadProperties(new Goate(), "" + this.parameters.get("file"));
        data.add(props);
        return data;
    }

    private Goate loadProperties(Goate props, String file) {
        if (props != null && file != null && new File(GoateUtils.getFilePath(file)).exists()) {
            String ext;
            String pf = "" + new GetFileAsString(file).explode().from("file::");
            if (!pf.isEmpty()) {
                pf = pf.replace("\n\r", "\r").replace("\r", "\n");
                for (String line : pf.split("\n")) {
                    String[] prop;
                    if (line == null || line.isEmpty() || line.startsWith("#") || (prop = line.split("=")).length < 2) continue;
                    String key = prop[0].trim();
                    if (key.endsWith("##")) {
                        props.put(prop[0].trim(), prop[1].trim());
                        continue;
                    }
                    props.getStrict(prop[0].trim(), prop[1].trim());
                }
            }
            String[] files = (ext = props.get("extends", null, String.class)) != null ? ext.split(",") : new String[]{};
            for (String extendedFile : files) {
                props = this.loadProperties(props.filterExclude("extends"), extendedFile);
            }
        }
        return props;
    }

    public PropertyFileDL file(String file) {
        this.setParameter("file", file);
        return this;
    }

    public PropertyFileDL file(File file) {
        this.setParameter("file", file);
        return this;
    }
}

