/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl;

import com.thegoate.Goate;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class Interpreter {
    BleatBox LOG = BleatFactory.getLogger(this.getClass());
    Goate data;
    Map<String, Class> dictionary = null;

    public Interpreter(Goate data) {
        this.data = data;
        if (this.data == null) {
            this.data = new Goate();
        }
        this.initDictionary();
    }

    public Object translate(Object value) {
        String check = "" + value;
        if (check.contains("::")) {
            check = check.substring(0, check.indexOf("::"));
            return this.translate("", check, value);
        }
        return value;
    }

    public Object translate(String key, String dsl, Object value) {
        DSL word = this.build(dsl, value);
        if (word != null) {
            value = word.source(key).evaluate(this.data);
        }
        return value;
    }

    public DSL build(String word, Object value) {
        DSL dsl = null;
        if (this.dictionary != null && this.dictionary.containsKey(word)) {
            try {
                dsl = (DSL)this.dictionary.get(word).getConstructor(Object.class).newInstance(value);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.LOG.error("Problem translating: " + e.getMessage(), e);
            }
        }
        return dsl;
    }

    protected void initDictionary() {
        try {
            if (this.dictionary == null) {
                new AnnotationFactory().using(GoateDSL.class.getMethod("word", new Class[0])).doDefault().annotatedWith(GoateDSL.class).buildDirectory();
            }
            this.dictionary = AnnotationFactory.directory.get(GoateDSL.class.getCanonicalName());
        }
        catch (Throwable e) {
            this.LOG.error("Problem initializing dsl: " + e.getMessage(), e);
        }
    }

    public Map<String, Class> getDictionary() {
        return this.dictionary;
    }
}

