/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl.words;

import com.thegoate.Goate;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

@GoateDSL(word="date")
@GoateDescription(description="returns current (local) date time in the given format as a string.", parameters={"the format for the date"})
public class DateCurrentDSL
extends DSL {
    public DateCurrentDSL(Object value) {
        super(value);
    }

    public static String date(String format) {
        return DateCurrentDSL.date(format, new Goate());
    }

    public static String date(String format, Goate data) {
        return "" + new DateCurrentDSL("date::" + format).evaluate(data);
    }

    @Override
    public Object evaluate(Goate data) {
        String datePattern = "" + this.get(1, data);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(datePattern);
        this.LOG.debug("Date Reformat", "Pattern: " + datePattern);
        LocalDateTime date = LocalDateTime.now();
        return date.format(dtf);
    }
}

