/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl.words;

import com.thegoate.Goate;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

@GoateDSL(word="date reformat")
@GoateDescription(description="reformats the given date format.", parameters={"the original date pattern", "the date string", "the new format"})
public class DateReformatDSL
extends DSL {
    protected String datePattern;
    protected DateTimeFormatter dtf;
    protected String dateOrigin;
    protected String datePattern2;
    protected DateTimeFormatter dtf2;

    public DateReformatDSL(Object value) {
        super(value);
    }

    public static String dateReformat(String originalPattern, String date, String newPattern) {
        return DateReformatDSL.dateReformat(originalPattern, date, newPattern, new Goate());
    }

    public static String dateReformat(String originalPattern, String date, String newPattern, Goate data) {
        return "" + new DateReformatDSL("date reformat::" + originalPattern + "," + date + "," + newPattern).evaluate(data);
    }

    @Override
    public Object evaluate(Goate data) {
        this.initFormat(data);
        LocalDate date = LocalDate.parse(this.dateOrigin, this.dtf);
        String dateFormatted = date.format(this.dtf2);
        this.LOG.debug("Date Reformat", "New Date: " + dateFormatted);
        return dateFormatted;
    }

    protected void initFormat(Goate data) {
        this.datePattern = "" + this.get(1, data);
        this.dtf = DateTimeFormatter.ofPattern(this.datePattern);
        this.LOG.debug("Date Reformat", "Pattern: " + this.datePattern);
        this.dateOrigin = "" + this.get(2, data);
        this.LOG.debug("Date Reformat", "Date: " + this.dateOrigin);
        this.datePattern2 = "" + this.get(3, data);
        this.dtf2 = DateTimeFormatter.ofPattern(this.datePattern2);
    }
}

