/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl.words;

import com.thegoate.Goate;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;

@GoateDSL(word="date shift")
@GoateDescription(description="shifts the date, in the given pattern, by the specified number of units (defaults to days)", parameters={"the date pattern, both the original date and the calculated date", "the original date", "the number of days to shift the date", "the time units to shift by: seconds(s), minutes(m), hours(h), days(d), weeks(w), months(n)"})
public class DateShiftDSL
extends DSL {
    protected String datePattern;
    protected DateTimeFormatter dtf;
    protected String dateOrigin;
    protected long dateShift;
    protected TemporalUnit shiftUnits;

    public DateShiftDSL(Object value) {
        super(value);
    }

    public static String dateShift(String pattern, String date, int numberOfDaysToShift) {
        return DateShiftDSL.dateShift(pattern, date, numberOfDaysToShift, "d", new Goate());
    }

    public static String dateShift(String pattern, String date, int numberOfDaysToShift, Goate data) {
        return DateShiftDSL.dateShift(pattern, date, numberOfDaysToShift, "d", data);
    }

    public static String dateShift(String pattern, String date, int numberToShiftBy, String units) {
        return DateShiftDSL.dateShift(pattern, date, numberToShiftBy, units, new Goate());
    }

    public static String dateShift(String pattern, String date, int numberToShiftBy, String units, Goate data) {
        return "" + new DateShiftDSL("date shift::" + pattern + "," + date + "," + numberToShiftBy + "," + units).evaluate(data);
    }

    @Override
    public Object evaluate(Goate data) {
        this.initShift(data);
        LocalDate date = LocalDate.parse(this.dateOrigin, this.dtf);
        date = date.plus(this.dateShift, this.shiftUnits);
        String dateShifted = date.format(this.dtf);
        this.LOG.debug("Date Shift", "New Date: " + dateShifted);
        return dateShifted;
    }

    protected void initShift(Goate data) {
        this.datePattern = "" + this.get(1, data);
        this.dtf = DateTimeFormatter.ofPattern(this.datePattern);
        this.LOG.debug("Date Shift", "Pattern: " + this.datePattern);
        this.dateOrigin = "" + this.get(2, data);
        this.LOG.debug("Date Shift", "Original Date: " + this.dateOrigin);
        this.dateShift = Long.parseLong("" + this.get(3, data));
        Object unit = this.get(4, data);
        String units = unit == null ? "d" : "" + unit;
        this.shiftUnits = this.findTemporalUnit(units);
    }

    protected TemporalUnit findTemporalUnit(String unit) {
        ChronoUnit u;
        switch (unit) {
            case "s": 
            case "seconds": {
                u = ChronoUnit.SECONDS;
                break;
            }
            case "m": 
            case "minutes": {
                u = ChronoUnit.MINUTES;
                break;
            }
            case "h": 
            case "hours": {
                u = ChronoUnit.HOURS;
                break;
            }
            case "d": 
            case "days": {
                u = ChronoUnit.DAYS;
                break;
            }
            case "w": 
            case "weeks": {
                u = ChronoUnit.WEEKS;
                break;
            }
            case "n": 
            case "months": {
                u = ChronoUnit.MONTHS;
                break;
            }
            default: {
                u = ChronoUnit.DAYS;
            }
        }
        return u;
    }
}

