/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl.words;

import com.thegoate.Goate;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.dsl.GoateDSL;
import com.thegoate.dsl.words.DateShiftDSL;
import java.time.LocalDateTime;

@GoateDSL(word="dateTime shift")
@GoateDescription(description="shifts the dateTime, in the given pattern, by the specified number of weeks(w), days(d), hours(h), minutes(m), seconds(s)", parameters={"the date pattern, both the original date and the calculated date", "the original date", "the number of units (defaults to days) to shift the date", "the time units to shift by: seconds(s), minutes(m), hours(h), days(d), weeks(w), months(n)"})
public class DateTimeShiftDSL
extends DateShiftDSL {
    public DateTimeShiftDSL(Object value) {
        super(value);
    }

    public static String dateTimeShift(String pattern, String date, int numberOfDaysToShift) {
        return DateTimeShiftDSL.dateTimeShift(pattern, date, numberOfDaysToShift, new Goate());
    }

    public static String dateTimeShift(String pattern, String date, int numberOfDaysToShift, Goate data) {
        return DateTimeShiftDSL.dateTimeShift(pattern, date, numberOfDaysToShift, "d", new Goate());
    }

    public static String dateTimeShift(String pattern, String date, int numberToShiftBy, String units) {
        return DateTimeShiftDSL.dateTimeShift(pattern, date, numberToShiftBy, units, new Goate());
    }

    public static String dateTimeShift(String pattern, String date, int numberToShiftBy, String units, Goate data) {
        return "" + new DateTimeShiftDSL("dateTime shift::" + pattern + "," + date + "," + numberToShiftBy + "," + units).evaluate(data);
    }

    @Override
    public Object evaluate(Goate data) {
        this.initShift(data);
        LocalDateTime date = LocalDateTime.parse(this.dateOrigin, this.dtf);
        date = date.plus(this.dateShift, this.shiftUnits);
        String dateShifted = date.format(this.dtf);
        this.LOG.debug("Date Shift", "New Date: " + dateShifted);
        return dateShifted;
    }
}

