/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl.words;

import com.thegoate.Goate;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.data.PropertyFileDL;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import com.thegoate.utils.GoateUtils;
import com.thegoate.utils.fill.FillString;
import java.io.File;
import java.util.List;

@GoateDSL(word="eut")
@GoateDescription(description="Returns the value of the specified property in the defined eut properties file.\n The eut can be specified by setting a system or environment variable called eut.\n The corresponding  property must be in the eut folder and be named <system/environment variable>.properties.\n The eut folder location may be configured by adding a file called eut.config, this file must be in the eut folder \n     but you may configure a different default name, a name pattern, file extension, and a location for the eut properties.\n     example eut/eut.config (default is the default properties file, including the path, to load if no profile or eut is specified):\ndefault=eut/local.properties\npattern=${profile}\nextension=properties\nlocation=eut\ndefault.profile=localdev", parameters={"The name of the property", "Optional default value."})
public class EutConfigDSL
extends DSL {
    protected static Goate eut = new Goate();
    protected static volatile boolean loaded = false;
    protected String path = "eut";
    protected String defaultPropeties = "eut/local.properties";
    protected String fileName = "${eut}";
    protected String extension = "properties";

    public EutConfigDSL(Object value) {
        super(value);
    }

    public static void clear() {
        loaded = false;
        eut = new Goate();
    }

    public static String eut(String key) {
        return EutConfigDSL.eut(key, null);
    }

    public static String eut(String key, String defaultValue) {
        return EutConfigDSL.eut(key, defaultValue, new Goate());
    }

    public static <T> T eut(String key, Object defaultValue, Class<T> type) {
        return EutConfigDSL.eut(key, defaultValue, type, new Goate());
    }

    public static String eut(String key, String defaultValue, Goate data) {
        return EutConfigDSL.eut(key, defaultValue, String.class, data);
    }

    public static <T> T eut(String key, Object defaultValue, Class<T> type, Goate data) {
        EutConfigDSL eut = new EutConfigDSL("eut::" + key + (defaultValue == null ? "" : "," + ("" + defaultValue).replace(",", "\\,")));
        return new Goate().get("chet", eut.evaluate(data), type);
    }

    @Override
    public Object evaluate(Goate data) {
        if (data.get("_goate_:eutConfig") != null) {
            eut = data.get("_goate_:eutConfig", (Object)eut, Goate.class);
        }
        eut.put("_init_", true);
        if (!loaded) {
            List<Goate> d;
            loaded = true;
            List<Goate> configs = new PropertyFileDL().file("eut/eut.config").load();
            Goate config = new Goate();
            if (configs.size() > 0) {
                config = configs.get(0);
            }
            if (data.get("eut", data.get("profile", config.get("default.profile", null))) == null) {
                this.LOG.debug("eut", "No profile found, will default to default properties.");
            }
            this.path = config.get("location", (Object)this.path, String.class);
            this.extension = config.get("extension", (Object)this.extension, String.class);
            this.defaultPropeties = config.get("default", (Object)this.defaultPropeties, String.class);
            this.fileName = config.get("pattern", (Object)this.fileName, String.class);
            String eutProfile = "" + new FillString(this.fileName).with(data);
            String file = this.path + "/" + eutProfile + "." + this.extension;
            if (!new File(GoateUtils.getFilePath(file)).exists()) {
                file = this.defaultPropeties;
            }
            if ((d = new PropertyFileDL().file(file).load()) != null && d.size() > 0) {
                eut = d.get(0);
                data.put("_goate_:eutConfig", eut);
            }
        }
        String key = "" + this.get(1, data);
        Object def = this.get(2, data);
        return data.get(key, eut != null ? (eut.get(key) == null ? def : eut.get(key)) : def);
    }
}

