/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl.words;

import com.thegoate.Goate;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import com.thegoate.utils.fill.serialize.DeSerializer;

@GoateDSL(word="pojo")
@GoateDescription(description="Returns the filled object filled with corresponding data from the goate collection.\n The pojo is filled out using the current goate collection.", parameters={"the class to be filled, needs to be the fully qualified package and class name, or use the class dsl or o dsl to reference a Class object", "the rest of the parameters are a comma separated list of generic type declarations if the pojo includes generics."})
public class PojoDSL
extends DSL {
    Goate fillData = new Goate();

    public PojoDSL(Object value) {
        super(value);
    }

    public static PojoDSL pojo(Object value) {
        return new PojoDSL("pojo::" + value);
    }

    public PojoDSL put(Goate data) {
        this.fillData.merge(data, false);
        return this;
    }

    public PojoDSL put(String key, Object value) {
        this.fillData.put(key, value);
        return this;
    }

    public Object evaluate() {
        return this.evaluate(this.fillData);
    }

    @Override
    public Object evaluate(Goate data) {
        Class klass = this.findClass(this.get(1, data));
        DeSerializer ds = new DeSerializer().data(data);
        for (int i = 2; i < this.definition.size(); ++i) {
            ds.T(this.findClass(this.get(i, data)));
        }
        return ds.build(klass);
    }

    private Class findClass(Object klass) {
        Class<?> theClass = null;
        if (klass instanceof Class) {
            theClass = (Class<?>)klass;
        } else {
            try {
                theClass = Class.forName("" + klass);
            }
            catch (ClassNotFoundException e) {
                this.LOG.warn("Failed to find the class: " + klass);
            }
        }
        return theClass;
    }
}

