/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.dsl.words;

import com.thegoate.Goate;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import com.thegoate.staff.GoateTask;
import com.thegoate.staff.GoateTaskContainer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@GoateDSL(word="do")
public class RunTask
extends DSL {
    Goate parameters = new Goate();
    AnnotationFactory af = new AnnotationFactory();

    public RunTask(Object value) {
        super(value);
    }

    public static RunTask task(String task) {
        return new RunTask("do::" + task);
    }

    public RunTask parameter(String key, Object value) {
        this.parameters.put(key, value);
        return this;
    }

    public Object run() {
        return this.run(new Goate());
    }

    public Object run(Goate data) {
        return this.evaluate(data);
    }

    @Override
    public Object evaluate(Goate data) {
        this.parameters.merge(data, false);
        String task = "" + this.get(1, this.parameters);
        Object result = null;
        Object[] constructorParams = null;
        if (this.definition.size() > 2) {
            constructorParams = new Object[this.definition.size() - 2];
            for (int i = 0; i < constructorParams.length; ++i) {
                constructorParams[i] = this.get(i + 2, this.parameters);
            }
        }
        try {
            this.af.annotatedWith(GoateTaskContainer.class).findByMethod(this.makeGeneric(task)).methodAnnotatedWith(GoateTask.class).constructorArgs(constructorParams);
            Object owner = this.findOwner();
            Method m = this.findTask();
            Object[] args = this.buildArgs(m, task, this.parameters);
            try {
                boolean accessible = m.isAccessible();
                this.LOG.debug("class: " + m.getDeclaringClass());
                this.LOG.debug("method: " + m.getName());
                this.LOG.debug("parameters: " + this.printArgs(args));
                m.setAccessible(true);
                result = m.invoke(owner, args);
                m.setAccessible(accessible);
            }
            catch (IllegalAccessException e) {
                this.LOG.error("Problem executing task: task\n" + e.getMessage(), e);
            }
            catch (InvocationTargetException ite) {
                result = ite.getCause();
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            this.LOG.error("There was a problem processing the word: " + this.value + "\n" + e.getMessage(), e);
        }
        return result;
    }

    protected String printArgs(Object[] args) {
        String arg = "";
        for (Object o : args) {
            arg = arg + "" + o + ", ";
        }
        int last = arg.lastIndexOf(", ");
        if (last < 0) {
            last = arg.length();
        }
        return arg.substring(0, last);
    }

    public Object findOwner() throws IllegalAccessException, InvocationTargetException, InstantiationException {
        Object owner = this.af.build();
        return owner;
    }

    public Method findTask() {
        Method m = this.af.getMethod();
        return m;
    }

    public String makeGeneric(String task) {
        String gen = task;
        while (gen.contains("${")) {
            String val = gen.substring(gen.indexOf("${") + 2, gen.indexOf("}"));
            gen = gen.replace("${" + val + "}", "&&var&&");
        }
        return gen.replaceAll("&&var&&", "\\${var}");
    }

    public Object[] buildArgs(Method m, String task, Goate data) {
        Object[] args = null;
        if (m != null) {
            args = new Object[m.getParameterCount()];
            Map<Long, String> values = this.extractValues(task);
            int index = 0;
            Object[] valKeys = this.filteredKeys(values);
            for (Parameter p : m.getParameters()) {
                Object v;
                Long ix = Long.parseLong("" + valKeys[index]);
                args[index] = v = data.get("" + values.get(ix), null);
                ++index;
            }
        }
        return args;
    }

    protected Map<Long, String> extractValues(String task) {
        ConcurrentHashMap<Long, String> vals = new ConcurrentHashMap<Long, String>();
        String params = task;
        while (params.contains("${")) {
            Long stamp = System.nanoTime();
            String val = params.substring(params.indexOf("${") + 2, params.indexOf("}"));
            params = params.replace("${" + val + "}", "" + stamp);
            vals.put(stamp, val);
        }
        return vals;
    }

    protected Object[] filteredKeys(Map<Long, String> map) {
        ArrayList<Long> list = new ArrayList<Long>();
        Set<Long> keys = map.keySet();
        if (map != null) {
            for (Long k : keys) {
                list.add(k);
            }
            Collections.sort(list);
        }
        return list.toArray();
    }
}

