/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect;

import com.thegoate.Goate;
import com.thegoate.expect.ExpectThreadExecuter;
import com.thegoate.expect.Expectation;
import com.thegoate.expect.ExpectationThreadBuilder;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.reflection.Executioner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ExpectEvaluator {
    final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    List<ExpectThreadExecuter> expectations = null;
    volatile StringBuilder failed = new StringBuilder("");
    volatile List<Goate> fails = Collections.synchronizedList(new ArrayList());
    volatile List<Goate> passes = Collections.synchronizedList(new ArrayList());
    volatile List<Goate> skipped = Collections.synchronizedList(new ArrayList());
    volatile List<Goate> zeroOrMore = Collections.synchronizedList(new ArrayList());

    public ExpectEvaluator(ExpectationThreadBuilder etb) {
        this.buildExpectations(etb);
    }

    protected void buildExpectations(ExpectationThreadBuilder etb) {
        this.expectations = etb.build();
    }

    public boolean evaluate() {
        return this.evaluate(10);
    }

    public boolean evaluate(int threadSize) {
        boolean result = true;
        this.failed = new StringBuilder("");
        this.process(threadSize);
        for (ExpectThreadExecuter expect : this.expectations) {
            if (!expect.status()) {
                result = false;
                this.LOG.info("Expect Evaluation", "detected failed expectations: " + expect.failedMessage());
                this.failed.append(expect.failedMessage());
                this.fails.addAll(expect.fails());
            }
            this.passes.addAll(expect.passes());
        }
        this.checkForSkipped();
        return result;
    }

    public List<ExpectThreadExecuter> expectations() {
        return this.expectations;
    }

    public List<Goate> fails() {
        return this.fails;
    }

    public List<Goate> passes() {
        return this.passes;
    }

    public List<Goate> zeroOrMore() {
        return this.zeroOrMore;
    }

    public List<Goate> skipped() {
        return this.skipped;
    }

    public String failed() {
        return this.failed != null ? this.failed.toString() : "no failed messages";
    }

    protected void process(int threadSize) {
        this.LOG.debug("starting executor to evaluate expectations.");
        if (new Executioner<ExpectThreadExecuter>(threadSize).process(this.expectations())) {
            this.LOG.debug("Expectations", "Evaluation finished successfully");
        } else {
            this.LOG.info("Expectations", "Evaluation did not finish successfully, at least one expectation was not executed for some reason.");
            this.failed.append("/nNot all expectation threads were executed successfully for some reason, please review the logs.");
            this.fails.add(new Goate().put("actual", this.expectations().size()).put("health check", "failed to execute all the threads for some reason."));
        }
    }

    private void checkForSkipped() {
        for (ExpectThreadExecuter expectation : this.expectations()) {
            Expectation ex = expectation.getExpectation();
            Goate eval = ex.getExpectations();
            for (String key : eval.keys()) {
                Goate exp = eval.get(key, null, Goate.class);
                if (this.checkInExpectationList(exp.get("actual"), exp.get("operator", null, String.class), this.passes()) || this.checkInExpectationList(exp.get("actual"), exp.get("operator", null, String.class), this.fails())) continue;
                if (!("" + exp.get("actual")).contains("*") && !("" + exp.get("actual")).contains("+")) {
                    this.skipped.add(exp);
                    continue;
                }
                if (("" + exp.get("actual")).contains("+")) continue;
                this.zeroOrMore.add(exp);
            }
        }
    }

    private boolean checkInExpectationList(Object actual, String operator, List<Goate> list) {
        String act = "" + actual;
        boolean result = false;
        for (Goate expectation : list) {
            if (!act.equals("" + expectation.get("actual", null)) || !operator.equals("" + expectation.get("operator", null, String.class))) continue;
            result = true;
            break;
        }
        return result;
    }
}

