/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect;

import com.thegoate.Goate;
import com.thegoate.expect.Expectation;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.utils.GoateUtils;
import java.util.ArrayList;
import java.util.List;

public class ExpectThreadExecuter
extends Thread {
    final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    volatile Expectation expectation = null;
    volatile boolean status = false;
    volatile boolean running = false;
    volatile boolean executing = false;
    long timeoutMS = 60000L;
    long period = 50L;
    long startTime = 0L;
    long endTime = 0L;
    volatile StringBuilder failed = new StringBuilder("");
    private final Object synchro = new Object();
    Goate data;

    public ExpectThreadExecuter(Expectation expectation) {
        this.expectation = expectation;
    }

    public void terminate() {
        this.executing = false;
    }

    public ExpectThreadExecuter timeout(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    public ExpectThreadExecuter period(long period) {
        this.period = period;
        return this;
    }

    public ExpectThreadExecuter setData(Goate data) {
        this.data = data;
        return this;
    }

    public Expectation getExpectation() {
        return this.expectation;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.synchro;
        synchronized (object) {
            this.status = false;
            if (this.expectation != null) {
                this.executing = true;
                this.timeoutMS = this.expectation.getRetryTimeout() < 0L ? this.timeoutMS : this.expectation.getRetryTimeout();
                this.period = this.expectation.getRetryPeriod() < 0L ? this.period : this.expectation.getRetryPeriod();
                long current = this.startTime = System.currentTimeMillis();
                boolean executedOnce = false;
                while (!executedOnce || this.executing && !this.status && current - this.startTime <= this.timeoutMS) {
                    this.status = this.expectation.evaluate();
                    executedOnce = true;
                    if (!this.status) {
                        GoateUtils.sleep(this.period, this.LOG);
                    }
                    current = System.currentTimeMillis();
                }
                if (!this.status) {
                    this.failed.append("The expectation(s) failed or timed out.\n");
                    this.failed.append(this.expectation.failed());
                }
                this.executing = false;
            }
            this.running = false;
        }
    }

    public boolean status() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String failedMessage() {
        Object object = this.synchro;
        synchronized (object) {
            return this.failed.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goate> fails() {
        Object object = this.synchro;
        synchronized (object) {
            return this.expectation != null ? this.expectation.fails() : new ArrayList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goate> passes() {
        Object object = this.synchro;
        synchronized (object) {
            return this.expectation != null ? this.expectation.passes() : new ArrayList();
        }
    }

    @Override
    public void start() {
        this.running = true;
        this.LOG.debug("starting: " + this.expectation.fullName());
        try {
            super.start();
        }
        catch (Throwable t) {
            this.LOG.debug("problem starting: " + this.expectation.fullName(), t);
            throw t;
        }
    }
}

