/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect;

import com.thegoate.Goate;
import com.thegoate.dsl.Interpreter;
import com.thegoate.expect.ExpectedBuilder;
import com.thegoate.expect.builder.Value;
import com.thegoate.expect.extras.Extra;
import com.thegoate.expect.extras.IgnoreOrder;
import com.thegoate.expect.extras.OneOrMore;
import com.thegoate.expect.extras.ZeroOrMore;
import com.thegoate.expect.test.SkipExpectation;
import com.thegoate.expect.validate.Validate;
import com.thegoate.locate.Locate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.logging.volume.VolumeKnob;
import com.thegoate.reflection.Executioner;
import com.thegoate.staff.Employee;
import com.thegoate.utils.compare.CompareUtil;
import com.thegoate.utils.fill.serialize.DeSerializer;
import com.thegoate.utils.fill.serialize.DefaultSource;
import com.thegoate.utils.fill.serialize.Serializer;
import com.thegoate.utils.togoate.ToGoate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Expectation {
    public static final String EmployeeWorkResult = "_goate_(%$#)_Employee Work Result";
    protected final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    String name = "";
    String expectedName = "";
    String id = "";
    Goate data = null;
    volatile Goate expect = new Goate();
    String simpleState = "";
    volatile Object actual;
    String operator = "";
    private Validate validator = null;
    volatile Object expected = null;
    long cachePeriod = 50L;
    Object from = null;
    Object fromExpected = null;
    Object source = null;
    boolean zeroOrMore = true;
    boolean ignoreOrder = false;
    String clearedState = null;
    StringBuilder failed = new StringBuilder("");
    String failureMessage = null;
    volatile List<Goate> fails = Collections.synchronizedList(new ArrayList());
    volatile List<Goate> passes = Collections.synchronizedList(new ArrayList());
    boolean includeExtras = false;
    private long retryTimeout = -42L;
    private long retryPeriod = -42L;
    private final Object synchro = new Object();

    public Validate getValidator() {
        return this.validator;
    }

    public Expectation validate(Validate validator) {
        return this.setValidator(validator);
    }

    public Expectation setValidator(Validate validator) {
        this.validator = validator;
        this.operator = validator.operator();
        this.simpleState = this.simpleState + "i";
        this.checkState(false);
        return this;
    }

    public long getRetryTimeout() {
        return this.retryTimeout;
    }

    public Expectation retryTimeout(long retryTimeout) {
        this.retryTimeout = retryTimeout;
        return this;
    }

    public long getRetryPeriod() {
        return this.retryPeriod;
    }

    public Expectation retryPeriod(long retryPeriod) {
        this.retryPeriod = retryPeriod;
        return this;
    }

    public Expectation(Goate data) {
        this.data = data;
    }

    public static Expectation build() {
        return Expectation.build(null);
    }

    public static Expectation build(Goate data) {
        if (data == null) {
            data = new Goate();
        }
        return new Expectation(data);
    }

    public String fullName() {
        return this.name + "#" + this.id + (this.expectedName.isEmpty() ? "" : "::" + this.expectedName) + (this.validator == null ? "" : "::" + this.validator.getName());
    }

    public String id() {
        return this.id;
    }

    public Expectation period(long period) {
        this.cachePeriod = period;
        return this;
    }

    public Expectation oneOrMore() {
        this.zeroOrMore = false;
        this.includeExtras = true;
        return this;
    }

    public Expectation zeroOrMore() {
        this.zeroOrMore = true;
        this.includeExtras = true;
        return this;
    }

    public Expectation ignoreOrder() {
        this.ignoreOrder = true;
        return this;
    }

    public Expectation fromClone(Object source) {
        Object clone = null;
        if (source != null) {
            Goate dna = new Serializer(source, DefaultSource.class).toGoate();
            clone = new DeSerializer().data(dna).build(source.getClass());
        }
        return this.from(clone);
    }

    public Expectation from(Object source) {
        return this.from(source, true);
    }

    protected Expectation from(Object source, boolean setFrom) {
        this.source = source;
        if (source instanceof String) {
            this.from = this.buildSource("" + source);
            if (this.from == null && setFrom) {
                this.from = source;
            }
        } else if (source != null && !source.equals(this.actual)) {
            this.from = source;
        }
        if ((this.name == null || this.name.isEmpty() || this.name.equals(this.actual)) && source != null) {
            this.name = VolumeKnob.volume(source);
        }
        return this;
    }

    public Object getFrom() {
        return this.from;
    }

    public Object getActual() {
        return this.actual;
    }

    public String getOperator() {
        return this.operator;
    }

    public Object getExpected() {
        return this.expected;
    }

    public Object getFromExpected() {
        return this.fromExpected;
    }

    public String getFailureMessage() {
        return this.failureMessage;
    }

    public Expectation addNewExpectation() {
        this.checkState(true);
        this.simpleState = "";
        this.actual = null;
        this.operator = "";
        this.expected = null;
        return this;
    }

    public Goate getExpectations() {
        return this.expect;
    }

    public Expectation add(Expectation expectation) {
        Goate ex = expectation.getExpectations();
        for (String key : ex.keys()) {
            Goate exp = (Goate)ex.get(key);
            this.actual(exp.getStrict("actual")).is("" + exp.getStrict("operator")).expected(exp.getStrict("expected")).failureMessage("" + exp.getStrict("failure message"));
        }
        return this;
    }

    public Expectation actualValue(Value value) {
        if (value != null) {
            this.actual(value.getLocator());
            if (value.getContainer() != null) {
                this.from(value.getContainer());
            }
        }
        return this;
    }

    public Expectation actual(Object actual) {
        if (actual instanceof Value) {
            return this.actualValue((Value)actual);
        }
        if (actual instanceof Locate) {
            actual = ((Locate)actual).toPath();
        }
        if (actual == null) {
            actual = "null::";
        }
        this.actual = actual;
        if (this.source == null) {
            this.from(actual, false);
        }
        this.simpleState = this.simpleState + "a";
        this.checkState(false);
        return this;
    }

    public Expectation isEqualTo(Object expected) {
        return this.is("==").expected(expected);
    }

    public Expectation isEqualToIgnoreOrder(Object expected) {
        return this.is("~==").expected(expected);
    }

    public Expectation isEqualToIgnoreCase(Object expected) {
        return this.is("~=").expected(expected);
    }

    public Expectation isNotEqualTo(Object expected) {
        return this.is("!=").expected(expected);
    }

    public Expectation isGreaterThan(Object expected) {
        return this.is(">").expected(expected);
    }

    public Expectation isGreaterThanOrEqualTo(Object expected) {
        return this.is(">=").expected(expected);
    }

    public Expectation isLessThan(Object expected) {
        return this.is("<").expected(expected);
    }

    public Expectation isLessThanOrEqualTo(Object expected) {
        return this.is("<=").expected(expected);
    }

    public Expectation isPresent(Object expected) {
        return this.is("isPresent").expected(expected);
    }

    public Expectation isEmpty(Object expected) {
        return this.is("isEmpty").expected(expected);
    }

    public Expectation isNull(Object expected) {
        return this.is("isNull").expected(expected);
    }

    public Expectation isIn(Object expected) {
        return this.is("contains").expected(expected);
    }

    public Expectation contains(Object expected) {
        return this.is("contains").expected(expected);
    }

    public Expectation is(String operator) {
        this.operator = operator;
        this.validator = null;
        this.simpleState = this.simpleState + "i";
        this.checkState(false);
        return this;
    }

    public Expectation is(Class operator) {
        CompareUtil cu = operator.getAnnotation(CompareUtil.class);
        return this.is(cu.operator());
    }

    public Expectation is(ExpectedBuilder expected) {
        this.is(expected.getClass());
        this.expected(expected.generateExpected());
        this.fromExpected(expected.fromExpected());
        return this;
    }

    public Expectation expectedValue(Value value) {
        if (value != null) {
            this.expected(value.getLocator());
            if (value.getContainer() != null) {
                this.fromExpected(value.getContainer());
            }
        }
        return this;
    }

    public Expectation expected(Object expected) {
        if (expected instanceof Value) {
            return this.expectedValue((Value)expected);
        }
        if (expected instanceof Locate) {
            expected = ((Locate)expected).toPath();
        }
        this.expected = expected;
        this.simpleState = this.simpleState + "c";
        this.checkState(false);
        return this;
    }

    public Expectation includeExtras() {
        this.includeExtras = true;
        return this;
    }

    protected void checkState(boolean force) {
        if (this.simpleState.length() == 3 && this.simpleState.contains("a") && this.simpleState.contains("i") && this.simpleState.contains("c") || force) {
            if (this.actual != null && this.operator != null && !this.operator.isEmpty()) {
                String key = "" + this.actual + this.operator + this.expected;
                Goate exp = new Goate();
                exp.put("actual", this.actual);
                exp.put("operator", this.operator);
                exp.put("expected", this.expected);
                exp.put("from", this.from);
                exp.put("failure message", this.failureMessage);
                if (this.includeExtras) {
                    Goate extras = new Goate();
                    extras.put("zeroOrMore", this.zeroOrMore);
                    extras.put("ignoreOrder", this.ignoreOrder);
                    exp.put("extras", extras);
                }
                this.expect.put(key, exp);
                this.actual = null;
                this.operator = "";
                this.expected = null;
                this.simpleState = "";
                this.failureMessage = null;
                this.clearedState = key;
            }
        } else {
            this.clearedState = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate() {
        Object object = this.synchro;
        synchronized (object) {
            this.failed = new StringBuilder("");
            this.fails = new ArrayList<Goate>();
            this.passes = new ArrayList<Goate>();
            boolean result = true;
            boolean forceFrom = false;
            if (this.from == null) {
                forceFrom = true;
                this.from = new Goate().put("actual", this.source);
            }
            try {
                this.source = this.from instanceof Employee ? ((Employee)((Employee)((Employee)this.from).expectation(this)).defaultPeriod(this.cachePeriod)).syncWork() : this.from;
            }
            catch (Throwable e) {
                this.LOG.error("Expectation", "Problem getting the source for comparison: " + e.getMessage(), e);
                this.logFail(e);
                this.source = null;
            }
            if (this.source != null) {
                if (this.source instanceof SkipExpectation) {
                    this.LOG.info("Expectation", "Specifically skipped an expectation.");
                } else {
                    ArrayList<Validate> checkers = new ArrayList<Validate>();
                    try {
                        Object keys;
                        this.LOG.debug("Expectation", "evaluating expectations.");
                        Iterator rtrn = new ToGoate(this.source).convert();
                        if (rtrn == null) {
                            rtrn = new Goate().get("source", this.source);
                        }
                        if (rtrn instanceof Goate && (keys = ((Goate)((Object)rtrn)).keys()).size() == 1 && keys.contains("_original_")) {
                            rtrn = this.source;
                        }
                        if (this.expect.size() == 0) {
                            this.logFail(new Exception("Expection not defined properly."), new Goate().put("actual", this.getActual()).put("from", this.getFrom()).put("operator", this.getOperator()).put("expected", this.getExpected()).put("fromExpected", this.getFromExpected()).put("failure message", this.getFailureMessage()));
                            result = false;
                        } else {
                            for (String key : this.expect.keys()) {
                                Goate exp = (Goate)this.expect.get(key);
                                if (forceFrom) {
                                    exp.put("actual", "actual");
                                    exp.put("from", this.from);
                                }
                                Validate checker = this.buildValidator(exp, key, rtrn);
                                checkers.add(checker);
                            }
                        }
                        result = this.playCheckers(checkers);
                    }
                    catch (Throwable t) {
                        result = false;
                        this.logFail(t);
                    }
                    finally {
                        for (Validate checker : checkers) {
                            this.passes.addAll(checker.getPasses());
                            if (checker.getFails().size() > 0) {
                                this.LOG.warn("Expectation Checker", "detected failed expectations.");
                            }
                            this.fails.addAll(checker.getFails());
                        }
                    }
                }
            } else {
                result = false;
                this.logFail(new Exception("The source of the data to check was not set"), this.expect);
            }
            return result;
        }
    }

    private boolean playCheckers(List<Validate> checkers) {
        boolean result = new Executioner<Validate>().process(checkers);
        for (Validate checker : checkers) {
            if (checker.result()) continue;
            result = false;
        }
        return result;
    }

    private void logFail(Throwable t) {
        Goate exp = new Goate();
        exp.put("from", this.fullName());
        exp.put("error", t.getMessage());
        this.logFail(t, exp);
    }

    private void logFail(Throwable t, Goate exp) {
        this.LOG.error(t.getMessage(), t);
        this.failed.append("there was a problem executing the work: " + t.getMessage() + "\n");
        this.fails.add(exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String failed() {
        Object object = this.synchro;
        synchronized (object) {
            if (this.from instanceof Employee) {
                this.failed.append(((Employee)this.from).getHrReport().printRecords());
            }
            return this.failed.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goate> fails() {
        Object object = this.synchro;
        synchronized (object) {
            return this.fails;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Goate> passes() {
        Object object = this.synchro;
        synchronized (object) {
            return this.passes;
        }
    }

    public Expectation define(String expectation) {
        if (this.data == null) {
            this.data = new Goate();
        }
        if (expectation != null && !expectation.isEmpty()) {
            String source = null;
            if (expectation.startsWith(">>")) {
                expectation = "" + this.data.getStrict(expectation.substring(2));
            }
            if (expectation.contains(">")) {
                source = expectation.substring(0, expectation.indexOf(">"));
                expectation = expectation.substring(expectation.indexOf(">") + 1);
            }
            String[] parts = expectation.split(",");
            Interpreter i = new Interpreter(this.data);
            this.from(source);
            Object act = i.translate(parts[0]);
            this.actual(act);
            if (parts.length > 1) {
                this.is("" + i.translate(parts[1]));
            }
            if (parts.length > 2) {
                this.expected(i.translate(parts[2]));
            }
            if (parts.length > 3) {
                this.processExtras(parts[3].split("&"));
            }
            if (parts.length > 4) {
                this.failureMessage(parts[4]);
            }
        }
        return this;
    }

    private void processExtras(String[] extras) {
        Interpreter i = new Interpreter(this.data);
        for (String extra : extras) {
            String[] pieces = extra.split(":=");
            String extraKey = "" + i.translate(pieces[0]);
            Object extraValue = null;
            if (pieces.length > 1) {
                extraValue = i.translate(pieces[1]);
            }
            EXTRAS.lookUp(extraKey).process(this, extraValue);
        }
    }

    public Expectation failureMessage(String failureMessage) {
        if (this.clearedState != null) {
            ((Goate)this.expect.get(this.clearedState)).put("failure message", failureMessage);
        } else {
            this.failureMessage = failureMessage;
        }
        return this;
    }

    public Expectation fromExpected(Object from) {
        this.fromExpected = from;
        this.expectedName = "" + from;
        this.checkState(false);
        return this;
    }

    public Expectation setData(Goate data) {
        this.data = data;
        this.initFrom(data, this.from);
        this.initFrom(data, this.fromExpected);
        return this;
    }

    protected void initFrom(Goate data, Object init) {
        if (init != null && init instanceof Employee) {
            ((Employee)init).mergeData(data);
        }
    }

    protected Employee buildSource(String source) {
        Interpreter i;
        Object workerId;
        Employee<Object> worker = null;
        if (this.data == null) {
            this.data = new Goate();
        }
        if ((workerId = (i = new Interpreter(this.data)).translate(source)) instanceof String) {
            source = "" + workerId;
            String[] sourceInfo = source.split("#");
            this.name = VolumeKnob.volume(sourceInfo[0]);
            this.id = sourceInfo.length > 1 ? sourceInfo[1] : "0";
            worker = Employee.recruit(source, this.data);
        }
        return worker;
    }

    protected Validate buildValidator(Goate exp, String key, Object rtrn) {
        Validate vlad = this.getValidator() != null ? this.getValidator().setExp(exp).setKey(key).setRtrn(rtrn).setPeriod(this.cachePeriod).setData(this.data) : Validate.lookUpGeneric(exp, key, this.from, this.fromExpected, rtrn, this.cachePeriod, this.data);
        return vlad;
    }

    static enum EXTRAS {
        ZERO_OR_MORE("zeroOrMore", new ZeroOrMore()),
        ONE_OR_MORE("oneOrMore", new OneOrMore()),
        IGNORE_ORDER("ignoreOrder", new IgnoreOrder());

        String label;
        Extra extra;

        private EXTRAS(String label, Extra extra) {
            this.label = label;
            this.extra = extra;
        }

        public EXTRAS process(Expectation expectation, Object value) {
            this.extra.processExtra(expectation, value);
            return this;
        }

        public static EXTRAS lookUp(String label) {
            EXTRAS extra = null;
            for (EXTRAS ext : EXTRAS.values()) {
                if (!ext.label.equalsIgnoreCase(label)) continue;
                extra = ext;
                break;
            }
            return extra;
        }
    }
}

