/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect;

import com.thegoate.Goate;
import com.thegoate.expect.ExpectThreadExecuter;
import com.thegoate.expect.Expectation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ExpectationThreadBuilder {
    List<Expectation> expectations = new ArrayList<Expectation>();
    Goate data = null;
    long timeoutMS = 0L;
    long period = 50L;
    boolean built = false;

    public boolean isBuilt() {
        return this.built;
    }

    public ExpectationThreadBuilder timeout(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    public ExpectationThreadBuilder period(long period) {
        this.period = period;
        return this;
    }

    public List<Expectation> expectations() {
        return this.expectations;
    }

    public ExpectationThreadBuilder(Goate data) {
        this.data = data;
    }

    public ExpectationThreadBuilder expect(Goate expectations) {
        if (expectations != null) {
            for (String key : expectations.keys()) {
                if (expectations.getStrict(key) instanceof String) {
                    this.expect("" + expectations.getStrict(key));
                    continue;
                }
                if (!(expectations.getStrict(key) instanceof Expectation)) continue;
                this.expect((Expectation)expectations.get(key));
            }
        }
        return this;
    }

    public ExpectationThreadBuilder expect(String definition) {
        return this.expect(new Expectation(this.data).define(definition));
    }

    public ExpectationThreadBuilder expect(Expectation expectation) {
        this.expectations.add(expectation);
        return this;
    }

    public List<ExpectThreadExecuter> build() {
        ConcurrentHashMap<String, ExpectThreadExecuter> map = new ConcurrentHashMap<String, ExpectThreadExecuter>();
        ArrayList<ExpectThreadExecuter> e = new ArrayList<ExpectThreadExecuter>();
        for (Expectation expectation : this.expectations) {
            if (map.containsKey(expectation.fullName())) {
                Expectation expTemp = ((ExpectThreadExecuter)map.get(expectation.fullName())).getExpectation();
                expTemp.addNewExpectation().add(expectation);
                continue;
            }
            ExpectThreadExecuter et = new ExpectThreadExecuter(expectation.setData(this.data).period(this.period - 1L)).timeout(this.timeoutMS).period(this.period);
            map.put(expectation.fullName(), et);
            e.add(et);
        }
        this.built = true;
        return e;
    }
}

