/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect.amp;

import com.thegoate.Goate;
import com.thegoate.annotations.IsDefault;
import com.thegoate.expect.amp.SkippedChannel;
import com.thegoate.expect.amp.StatusAmplifier;
import com.thegoate.logging.volume.amp.GoateAmplifier;

@GoateAmplifier(type=SkippedChannel.class)
@IsDefault(forType=true)
public class SkippedAmplifier
extends StatusAmplifier {
    public SkippedAmplifier(Object message) {
        super(message);
    }

    @Override
    protected void setStatus() {
    }

    @Override
    protected void logVolume(Goate p) {
        super.logVolume(p);
        if (p.get("failure message", null) == null) {
            p.drop("failure message");
        }
    }

    @Override
    protected String amplify() {
        StringBuilder full = new StringBuilder();
        StringBuilder ss = new StringBuilder();
        boolean skipped = false;
        for (Goate exp : this.ev.skipped()) {
            this.logVolume(exp);
            skipped = true;
            ss.append("\n--------------------\n");
            ss.append(exp.toString("\t", ""));
        }
        if (skipped) {
            ss.append("\n--------------------\n");
            full.append("\nfailed (skipped)").append((CharSequence)ss);
        }
        return full.toString();
    }

    @Override
    public boolean isType(Object check) {
        return false;
    }
}

