/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect.amp;

import com.thegoate.Goate;
import com.thegoate.dsl.words.EutConfigDSL;
import com.thegoate.expect.ExpectEvaluator;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.logging.BleatLevel;
import com.thegoate.logging.volume.amp.BasicAmplifier;
import java.util.List;
import java.util.logging.Level;

public abstract class StatusAmplifier
extends BasicAmplifier {
    protected BleatBox LOG = BleatFactory.getLogger(this.getClass());
    protected BleatLevel level = this.LOG.level();
    protected boolean mute = false;
    protected String test = null;
    protected ExpectEvaluator ev;
    protected List<Goate> status;
    protected final String expectSeparator = "\n--------------------\n";

    public StatusAmplifier(Object message) {
        super(message);
    }

    public StatusAmplifier muteFrom(boolean mute) {
        this.mute = mute;
        return this;
    }

    public StatusAmplifier testName(String test) {
        this.test = test;
        return this;
    }

    protected void logVolume(Goate p) {
        if (EutConfigDSL.eut("expect.scenario", false, Boolean.class).booleanValue()) {
            p.put("_scenario", this.test);
        }
        if (this.mute || this.level.isLoudEnough(Level.WARNING)) {
            p.drop("from");
            p.drop("fromExpected");
        }
        if (this.level.isLoudEnough(Level.SEVERE)) {
            p.drop("actual");
            p.drop("expected");
        }
        if (p.get("actual") != null && p.get("actual") instanceof String) {
            if (p.get("actual", (Object)"", String.class).equals(p.get("from"))) {
                p.drop("from");
            }
            p.put("actual", p.get("actual", (Object)"", String.class).replace("_goate_(%$#)_", ""));
        }
    }

    @Override
    public String amplify(Object message) {
        this.ev = (ExpectEvaluator)message;
        this.setStatus();
        return this.amplify();
    }

    protected abstract void setStatus();

    protected String amplify() {
        StringBuilder ps = new StringBuilder();
        for (Goate p : this.status) {
            this.logVolume(p);
            ps.append("\n--------------------\n");
            ps.append(p.toString("\t", ""));
        }
        if (ps.length() > 0) {
            ps.append("\n--------------------\n");
        }
        return ps.toString();
    }
}

