/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect.builder;

import com.thegoate.expect.Expectation;
import com.thegoate.expect.builder.Value;
import com.thegoate.utils.get.Get;
import java.util.ArrayList;
import java.util.List;

public abstract class ExpectationBuilder {
    protected Object from;
    protected Object fromExpected;
    protected Object actual;
    protected Object expected;
    private List<Expectation> expectations = new ArrayList<Expectation>();
    protected Value actualValue;
    protected Value expectedValue;
    protected long period = -42L;
    protected long timeoutMS = -42L;

    public abstract List<Expectation> build();

    protected ExpectationBuilder expect(Expectation expectation) {
        this.expectations.add(expectation.retryTimeout(this.timeoutMS).retryPeriod(this.period));
        return this;
    }

    protected List<Expectation> getExpectations() {
        return this.expectations;
    }

    public ExpectationBuilder actualValue(Object value) {
        if (value instanceof Value) {
            this.actualValue = (Value)value;
            if (value != null) {
                this.setActual(this.actualValue.getLocator());
                this.setFrom(this.actualValue.getContainer());
            }
        } else {
            this.setActual(value);
        }
        return this;
    }

    public ExpectationBuilder expectedValue(Object value) {
        if (value instanceof Value) {
            this.expectedValue = (Value)value;
            if (value != null) {
                this.setExpected(this.expectedValue.getLocator());
                this.setFromExpected(this.expectedValue.getContainer());
            }
        } else {
            this.setExpected(value);
        }
        return this;
    }

    public ExpectationBuilder timeout(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return this;
    }

    public ExpectationBuilder period(long period) {
        this.period = period;
        return this;
    }

    public Object getFrom() {
        return this.from;
    }

    public ExpectationBuilder setFrom(Object from) {
        if (this.actualValue == null) {
            this.actualValue = new Value().from(from);
        }
        this.from = from;
        return this;
    }

    public Object getFromExpected() {
        return this.fromExpected;
    }

    public ExpectationBuilder setFromExpected(Object fromExpected) {
        if (this.expectedValue == null) {
            this.expectedValue = new Value().from(fromExpected);
        }
        this.fromExpected = fromExpected;
        return this;
    }

    public Object getActual() {
        Object a = this.actual;
        if (this.from != null) {
            a = !("" + this.actual).contains("*") && !("" + this.actual).contains("+") ? new Get(this.actual).from(this.from) : this.from;
        }
        return a;
    }

    public ExpectationBuilder setActual(Object actual) {
        if (this.actualValue == null) {
            this.actualValue = new Value(actual);
        }
        this.actual = actual;
        return this;
    }

    public Object getExpected() {
        return this.expected;
    }

    public ExpectationBuilder setExpected(Object expected) {
        if (this.expectedValue == null) {
            this.expectedValue = new Value(expected);
        }
        this.expected = expected;
        return this;
    }
}

