/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.expect.builder;

import com.thegoate.Goate;
import com.thegoate.expect.Expectation;
import com.thegoate.expect.builder.ExpectationBuilder;
import com.thegoate.expect.validate.ValidatePresence;
import com.thegoate.locate.Locate;
import com.thegoate.utils.togoate.ToGoate;
import java.util.ArrayList;
import java.util.List;

public class ModelIsPresentOptional
extends ExpectationBuilder {
    protected List<String> optionalModel = new ArrayList<String>();

    @Override
    public Object getExpected() {
        Goate model = new ToGoate(super.getExpected()).convert();
        if (model == null) {
            model = new Goate();
        }
        return model;
    }

    private boolean someParentIsOptional(String key) {
        boolean optional = false;
        String parent = key;
        while (parent.contains(".")) {
            if (this.isOptional(parent)) {
                optional = true;
            }
            parent = parent.substring(0, parent.lastIndexOf(46));
        }
        return optional;
    }

    private boolean isOptional(String key) {
        return this.optionalModel.parallelStream().anyMatch(key::matches);
    }

    private Goate findParentsMatchingPattern(String key, Goate results) {
        String pattern = key.substring(0, key.lastIndexOf(46)).replace(".", "\\.").replaceAll("[0-9]+", "[0-9]*");
        return results.filterStrict(pattern);
    }

    @Override
    public List<Expectation> build() {
        Goate model = new ToGoate(this.getExpected()).convert();
        Goate results = new ToGoate(this.getActual()).convert();
        for (String key : model.keys()) {
            if (this.isOptional(key)) continue;
            if (this.someParentIsOptional(key)) {
                Goate parents = this.findParentsMatchingPattern(key, results);
                for (String pKey : parents.keys()) {
                    this.addExpect(pKey + key.substring(key.lastIndexOf(46)));
                }
                continue;
            }
            this.addExpect(key.replaceAll("\\.[0-9]+", ".+"));
        }
        return this.getExpectations();
    }

    private void addExpect(String key) {
        String actualKey = key;
        if (this.from != null && (("" + this.actual).contains("*") || ("" + this.actual).contains("+"))) {
            actualKey = "" + this.actual + "." + actualKey;
        }
        this.expect(Expectation.build().actual(actualKey).from(this.getActual()).isPresent(true).validate(new ValidatePresence()));
    }

    public ModelIsPresentOptional addOptionalField(String field) {
        this.optionalModel.add(field);
        return this;
    }

    public ModelIsPresentOptional addOptionalField(Locate path) {
        return this.addOptionalField(path.toPath());
    }
}

