/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.info;

import com.thegoate.Goate;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.info.Info;

public class GoateEncyclopedia {
    private Goate encyclopedia = null;

    public GoateEncyclopedia buildIndex() {
        try {
            if (this.encyclopedia == null) {
                new AnnotationFactory().doDefault().annotatedWith(Info.class).buildDirectory();
                this.encyclopedia = new Goate();
            }
            AnnotationFactory.directory.get(Info.class.getCanonicalName()).forEach((key, value) -> {
                Goate index = new Goate();
                index.put("_class", value);
                Info info = value.getAnnotation(Info.class);
                GoateDescription description = value.getAnnotation(GoateDescription.class);
                String desc = "NOT SET, PLEASE ADD @GoateDescription";
                if (description != null) {
                    desc = description.description();
                }
                index.put("_description", desc);
                index.put("_classifier", info.classifier());
                index.put("_tags", info.tags());
                index.put("_tags_string", this.tags(info.tags()));
                index.put("_sub_topics", new Goate());
                this.encyclopedia.put((String)key, index);
            });
        }
        catch (Throwable e) {
            System.out.println("Problem initializing encyclopedia: " + e.getMessage());
            e.printStackTrace();
        }
        return this;
    }

    private String tags(String[] tags) {
        StringBuilder tag_string = new StringBuilder("{");
        boolean first = true;
        for (String tag : tags) {
            if (!first) {
                tag_string.append(", ");
            }
            tag_string.append(tag);
            first = false;
        }
        return tag_string.append("}").toString();
    }

    public Goate getEncyclopedia() {
        return this.encyclopedia;
    }

    public static void main(String[] args) {
        GoateEncyclopedia ged = new GoateEncyclopedia();
        ged.buildIndex();
        StringBuilder book = new StringBuilder("");
        Goate encyclopedia = ged.getEncyclopedia();
        for (String key : encyclopedia.keys()) {
            Goate volume = encyclopedia.get(key, null, Goate.class);
            if (volume == null) continue;
            book.append(volume.get("_class", String.class, Class.class).getSimpleName()).append(": \n").append("\tdescription: ").append(volume.get("_description", (Object)"UNDEFINED", String.class)).append("\n").append("\trelated topics: ").append(volume.get("_tags_string", (Object)"{}", String.class)).append("\n").append("\tmethod of look up: ").append(volume.get("_classifier", (Object)"", String.class)).append("\n").append("\t").append(key).append("\n");
        }
        System.out.print(book.toString());
    }
}

