/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.locate;

public class Locate {
    protected StringBuilder path = new StringBuilder();
    private String oneOrMoreNumber = "([0-9])+";
    private String zeroOrMoreNumber = "([0-9])*";

    public static Locate start(String start) {
        return Locate.path().match(start);
    }

    public static Locate path() {
        return new Locate();
    }

    public Locate wildcardIndex() {
        return this.anyNumberZeroOrMore();
    }

    public Locate wildcardIndex(int expectedSize) {
        return this.matchNTimes(this.zeroOrMoreNumber, expectedSize);
    }

    public Locate wildcardIndex(int expectedSize, int startingIndex) {
        return this.matchNTimesStartingAt(this.zeroOrMoreNumber, expectedSize, startingIndex);
    }

    public Locate wildcardIndexOneOrMore() {
        return this.anyNumberOneOrMore();
    }

    public Locate matchIndex() {
        return this.wildcardIndex();
    }

    public Locate matchIndex(int matchIndex) {
        return this.wildcardIndex();
    }

    public Locate dot() {
        this.path.append("\\.");
        return this;
    }

    public Locate anyNumberOneOrMore() {
        this.path.append(this.oneOrMoreNumber);
        return this;
    }

    public Locate anyNumberZeroOrMore() {
        this.path.append(this.zeroOrMoreNumber);
        return this;
    }

    public Locate anyLetterOneOrMore() {
        this.path.append("([a-zA-Z])+");
        return this;
    }

    public Locate anyLetterZeroOrMore() {
        this.path.append("([a-zA-Z])*");
        return this;
    }

    public Locate match(String pattern) {
        this.path.append(pattern);
        return this;
    }

    public Locate matchZeroOrMore(String pattern) {
        this.path.append("(").append(pattern).append(")*");
        return this;
    }

    public Locate matchOneOrMore(String pattern) {
        this.path.append("(").append(pattern).append(")+");
        return this;
    }

    public Locate matchNTimes(String pattern, int numberOfTimesToMatch) {
        this.path.append("{").append(numberOfTimesToMatch).append("}");
        return this;
    }

    public Locate matchNTimesStartingAt(String pattern, int numberOfTimesToMatch, int start) {
        this.path.append(pattern).append("{").append(start).append(",").append(numberOfTimesToMatch).append("}");
        return this;
    }

    public Locate nTimes(int numberOfTimesToMatch) {
        this.path.insert(0, "((").append("){").append(numberOfTimesToMatch).append("})");
        return this;
    }

    public Locate nTimesStartingAt(int numberOfTimesToMatch, int start) {
        this.path.insert(0, "((").append("){").append(start).append(",").append(numberOfTimesToMatch).append("})");
        return this;
    }

    public String end() {
        return this.toPath();
    }

    public String end(String match) {
        this.path.append(match);
        return this.toPath();
    }

    public String toPath() {
        return this.path.toString();
    }
}

