/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.logging;

import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatLevel;
import java.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BleatBoxBase
implements BleatBox {
    protected Logger LOG;
    protected Class loggingClass;
    protected BleatLevel volume;
    StringBuilder buffer = new StringBuilder();
    String bufferTitle = "";

    public BleatBoxBase(Class logger) {
        this.loggingClass = logger;
        this.LOG = LoggerFactory.getLogger((Class)logger);
        this.setVolume(this.LOG.isDebugEnabled(), this.LOG.isErrorEnabled(), this.LOG.isInfoEnabled(), this.LOG.isTraceEnabled(), this.LOG.isWarnEnabled());
    }

    protected void setVolume(boolean debug, boolean error, boolean info, boolean trace, boolean warn) {
        if (trace) {
            this.setVolume(Level.FINE);
        } else if (debug) {
            this.setVolume(Level.CONFIG);
        } else if (info) {
            this.setVolume(Level.INFO);
        } else if (warn) {
            this.setVolume(Level.WARNING);
        } else if (error) {
            this.setVolume(Level.SEVERE);
        } else {
            this.setVolume(Level.INFO);
        }
    }

    @Override
    public BleatBox setVolume(Level volume) {
        this.volume = BleatLevel.level(volume, this.loggingClass.getName());
        return this;
    }

    @Override
    public BleatLevel level() {
        return this.volume;
    }

    @Override
    public void infoBuffer(String message) {
        this.infoBuffer(null, message);
    }

    @Override
    public void infoBuffer(String title, String message) {
        this.bufferTitle = title;
        if (this.buffer == null) {
            this.buffer = new StringBuilder();
        }
        this.buffer.append(message);
    }

    @Override
    public void flush() {
        if (this.buffer.length() > 0) {
            this.info(this.bufferTitle, this.buffer.toString());
            this.buffer = new StringBuilder();
        }
    }
}

