/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.logging;

import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.logging.Bleat;
import com.thegoate.logging.BleatBox;
import com.thegoate.reflection.GoateReflection;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BleatFactory {
    protected static Logger LOG = LoggerFactory.getLogger(BleatFactory.class);

    public static BleatBox getLogger(Class logFromClass) {
        BleatBox bb = null;
        AnnotationFactory af = new AnnotationFactory().doDefault().annotatedWith(Bleat.class).buildDirectory();
        Map<String, Class> dir = af.getDirectory(Bleat.class.getCanonicalName());
        Class def = dir.get("default");
        Class logger = null;
        for (String c : dir.keySet()) {
            if (def == null || def.equals(dir.get(c))) continue;
            logger = dir.get(c);
            break;
        }
        if (logger == null) {
            logger = def;
        }
        if (logger != null) {
            GoateReflection gr = new GoateReflection();
            Object[] args = new Object[]{logFromClass};
            try {
                bb = (BleatBox)gr.findConstructor(logger.getConstructors(), args).newInstance(args);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOG.error("Failed initializing the logger: " + e.getMessage(), (Throwable)e);
            }
        }
        return bb;
    }
}

