/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.metrics;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import java.util.HashMap;
import java.util.Map;

public class Stopwatch {
    public static Stopwatch global = new Stopwatch();
    private final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    private volatile Goate timers = new Goate();
    private volatile String started = null;

    public Stopwatch() {
        this.lap(":overall:");
    }

    public Timer lap(String lap) {
        this.LOG.debug("Stopwatch", "lap: " + lap);
        return this.timers.get(lap, (Object)new Timer(), Timer.class);
    }

    public Stopwatch start() {
        return this.start(":overall:");
    }

    public Stopwatch start(String lap) {
        return this.start(lap, System.nanoTime());
    }

    public Stopwatch start(String lap, long start) {
        if (!lap.equals(":overall:") && this.lap(":overall:").getStart() == 0L) {
            this.start(":overall:", start);
            this.started = lap;
        }
        this.LOG.debug("Stopwatch", "Lap(" + lap + ") start: " + start);
        this.lap(lap).start(start);
        return this;
    }

    public Stopwatch stop() {
        return this.stop(":overall:");
    }

    public Stopwatch stop(String lap) {
        return this.stop(lap, System.nanoTime());
    }

    public Stopwatch stop(String lap, long stop) {
        if (lap.equals(this.started)) {
            this.stop(":overall:", stop);
        }
        this.LOG.debug("Stopwatch", "Lap(" + lap + ") stop: " + stop);
        this.lap(lap).stop(stop);
        return this;
    }

    public Stopwatch split(String lap) {
        if (lap != null) {
            this.lap(lap).split();
        }
        return this;
    }

    public void stopAll() {
        for (String lap : this.timers.keys()) {
            Timer clock = this.timers.get(lap, null, Timer.class);
            if (clock.getStop() != 0L) continue;
            clock.stop();
        }
    }

    public void clearAllLaps() {
        this.timers = new Goate();
    }

    public void clearLaps(String lapPattern) {
        for (String lap : this.timers.keys()) {
            if (!lap.contains(lapPattern)) continue;
            this.timers.drop(lap);
        }
    }

    public Goate getTimers() {
        return this.timers;
    }

    public class Timer {
        long start = 0L;
        long stop = 0L;
        Map<String, Long> splits = new HashMap<String, Long>();

        public Map<String, Long> splits() {
            return this.splits;
        }

        void split() {
            this.split("" + this.splits.size());
        }

        void split(String split) {
            this.splits.put(split, System.nanoTime());
        }

        void start(long time) {
            if (this.start == 0L) {
                if (time >= 0L) {
                    this.start = time;
                } else {
                    this.start();
                }
            }
        }

        void stop(long time) {
            if (this.stop == 0L) {
                if (time >= 0L) {
                    this.stop = time;
                } else {
                    this.stop();
                }
            }
        }

        void start() {
            this.start(System.nanoTime());
        }

        void stop() {
            this.stop(System.nanoTime());
        }

        public long getTime() {
            return this.stop - this.start;
        }

        public long getStart() {
            return this.start;
        }

        public long getStop() {
            return this.stop;
        }
    }
}

