/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.reflection;

import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.reflection.test.SkipThread;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Executioner<T> {
    BleatBox LOG = BleatFactory.getLogger(this.getClass());
    int threadPoolSize = 1;

    public Executioner() {
    }

    public Executioner(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(List<T> threads) {
        ExecutorService es = Executors.newFixedThreadPool(this.threadPoolSize);
        boolean running = true;
        int expected = threads.size();
        ArrayList futures = new ArrayList();
        for (Object thread : threads) {
            if (!(thread instanceof Thread) || thread instanceof SkipThread) continue;
            futures.add(es.submit((Thread)thread));
        }
        int completed = 0;
        while (running) {
            running = false;
            completed = 0;
            for (Future future : futures) {
                if (!future.isDone()) {
                    running = true;
                    continue;
                }
                ++completed;
            }
        }
        try {
            this.LOG.debug("shutting down executor");
            es.shutdown();
            es.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.LOG.error("interrupted: " + e.getMessage(), e);
        }
        finally {
            if (!es.isTerminated()) {
                this.LOG.error("force cancel non-finished tasks");
            }
            es.shutdownNow();
            this.LOG.debug("shutdown finished");
        }
        return expected == completed;
    }
}

