/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.staff;

import com.thegoate.Goate;
import com.thegoate.annotations.AnnotationEvaluator;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.expect.Expectation;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.metrics.Stopwatch;
import com.thegoate.staff.GoateJob;
import com.thegoate.staff.HealthRecord;
import com.thegoate.staff.Worker;
import com.thegoate.utils.togoate.ToGoate;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public abstract class Employee<T>
implements Worker<Employee, T> {
    protected final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    protected static final BleatBox slog = BleatFactory.getLogger(Employee.class);
    protected HealthRecord hr = new HealthRecord();
    protected Expectation expectation = null;
    protected Goate data;
    protected Goate definition = new Goate();
    protected String name = "";
    protected volatile long startTime = 0L;
    protected volatile T result = null;
    protected long period = 50L;
    protected boolean periodHasBeenSet = false;

    @Override
    public HealthRecord getHrReport() {
        return this.hr;
    }

    @Override
    public Employee<T> setName(String name) {
        this.name = name;
        return this;
    }

    public Employee<T> expectation(Expectation expectation) {
        this.expectation = expectation;
        return this;
    }

    @Override
    public String parameterName(String parameter) {
        return this.name + (this.name.isEmpty() ? "" : ".") + parameter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameDef() {
        return this.name + ".definition";
    }

    @Override
    public Employee<T> initData() {
        if (this.data == null) {
            this.data = new Goate();
        }
        return this;
    }

    protected Object param(String paramName) {
        return this.param(paramName, null);
    }

    protected Object param(String paramName, Object def) {
        return this.definition != null ? this.definition.get(paramName, def) : def;
    }

    @Override
    public Employee<T> setData(Goate data) {
        this.data = data;
        new AnnotationEvaluator().process(this, this.getClass());
        return this;
    }

    @Override
    public Employee<T> defaultPeriod(long period) {
        if (!this.periodHasBeenSet) {
            this.period = period;
        }
        return this;
    }

    @Override
    public Employee<T> period(long period) {
        this.period = period;
        this.periodHasBeenSet = true;
        return this;
    }

    public final synchronized T syncWork() {
        return this.syncWork(this.period);
    }

    public final synchronized T syncWork(long waitMs) {
        if (System.currentTimeMillis() - this.startTime > waitMs) {
            this.result = this.work();
            this.startTime = System.currentTimeMillis();
        }
        return this.result;
    }

    @Override
    public Employee<T> clockIn() {
        return this;
    }

    @Override
    public final T work() {
        this.result = null;
        String lap = "" + System.nanoTime();
        try {
            if (this.data != null && this.data.get("lap", null) != null) {
                String lt = this.data.get("lap", (Object)lap, String.class);
                if (!lt.isEmpty()) {
                    lap = lt;
                }
                Stopwatch.global.start(lap);
            }
            this.result = ((Employee)this.clockIn()).doWork();
        }
        catch (Throwable t) {
            try {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream((OutputStream)bs, true, "utf-8");
                t.printStackTrace(ps);
                String stack = new String(bs.toByteArray(), StandardCharsets.UTF_8);
                this.hr.report(t.getMessage(), stack);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            throw t;
        }
        finally {
            if (this.data != null && this.data.get("lap", null) != null) {
                Stopwatch.global.split(lap);
            }
        }
        return this.result;
    }

    @Override
    public Goate scrub(Goate data) {
        String[] baseScrub = new String[]{"Scenario", "job", "abstract", "extends", "groups", "expect", "override", this.getName() + "\\.definition"};
        Goate scrubbed = this.clean(new Goate().merge(data, false), baseScrub);
        return this.clean(scrubbed, this.detailedScrub());
    }

    @Override
    public Goate clean(Goate data, String[] scrub) {
        if (scrub != null) {
            for (String key : scrub) {
                data.scrub(key);
            }
        }
        return data;
    }

    @Override
    public abstract String[] detailedScrub();

    public final Employee<T> build() {
        return this.init();
    }

    @Override
    public Employee<T> init(Goate data) {
        this.setData(data);
        if (data != null) {
            Object def = data.get(this.getName() + ".definition");
            def = def != null ? def : data;
            this.definition = new ToGoate(def).convert();
            this.definition.merge(this.scrub(data), false);
        }
        return this.init();
    }

    @Override
    public Employee<T> mergeData(Goate data) {
        this.definition.merge(this.scrub(data), false);
        return this;
    }

    protected abstract Employee<T> init();

    protected abstract T doWork();

    public static Employee recruit(Class job, Goate data) {
        GoateJob theJob = job.getAnnotation(GoateJob.class);
        Employee<Object> employee = null;
        if (theJob != null) {
            employee = Employee.recruit(theJob.jobs()[0], data);
        }
        return employee;
    }

    public static Employee<Object> recruit(String job, Goate data) {
        return Employee.recruit(job, data, null, Object.class);
    }

    public static <T> Employee<T> recruit(String job, Goate data, Class<T> type) {
        return Employee.recruit(job, data, null, type);
    }

    public static Employee<Object> recruit(String job, Goate definition, Goate parentData) {
        return Employee.recruit(job, definition, parentData, Object.class);
    }

    public static <T> Employee<T> recruit(String job, Goate definition, Goate parentData, Class<T> type) {
        Class recruit;
        Employee employee = null;
        String id = "";
        if (job.contains("#")) {
            id = job.substring(job.indexOf("#") + 1);
            job = job.substring(0, job.indexOf("#"));
        }
        if ((recruit = Employee.findEmployee(job)) != null) {
            try {
                employee = (Employee)recruit.newInstance();
                employee.setName(job + (id.isEmpty() ? "" : "#" + id));
            }
            catch (IllegalAccessException | InstantiationException e) {
                slog.error("Problem recruiting the employee: " + e.getMessage(), e);
            }
        }
        if (employee != null) {
            if (definition != null) {
                definition.merge(employee.scrub(parentData), false);
            }
            employee.init(definition);
        }
        return employee;
    }

    protected static Class findEmployee(String job) {
        Class klass = null;
        try {
            klass = new AnnotationFactory().find(job).using(GoateJob.class.getMethod("jobs", new Class[0])).annotatedWith(GoateJob.class).lookUp();
        }
        catch (NoSuchMethodException e) {
            slog.error("problem building directory of jobs: " + e.getMessage(), e);
        }
        return klass;
    }
}

