/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.staff;

import com.thegoate.Goate;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.expect.ExpectEvaluator;
import com.thegoate.expect.Expectation;
import com.thegoate.expect.ExpectationThreadBuilder;
import com.thegoate.staff.Employee;
import com.thegoate.staff.GoateJob;
import com.thegoate.utils.togoate.ToGoate;

@GoateJob(jobs={"work until"})
@GoateDescription(description="Run the defined job until the condition is met or it timesout. The default time out is 15 seconds.", parameters={"timeout = the timeout duration in milliseconds, defaults to 15000, set a negative time to enver timeout.", "period = the period in milliseconds at which to re-run the job, defaults to 1000", "work = the definition of the job to execute", "return last = true/false to always return the last result, if false returns null, defaults to false", "expect = the array, [], of conditions/expectations that should be met to consider the job completed.", "timeout_expect = the timeout in milliseconds for the expected conditions to be checked, defaults to 50mS, optional and not usually needed", "period_expect = the period in milliseconds at which to check the expected condtions, defaults to 50mS, optional and not usually needed"})
public class WorkUntilConditionMet
extends Employee {
    private Employee actualJob;
    private Long timeout = 15000L;
    private Long period = 1000L;
    private boolean lastReturn = false;

    public WorkUntilConditionMet returnLast() {
        this.lastReturn = true;
        this.definition.put("return last", this.lastReturn);
        return this;
    }

    public WorkUntilConditionMet job(String job) {
        return this.setJob(job);
    }

    public WorkUntilConditionMet job(Employee job) {
        return this.setJob(job);
    }

    private WorkUntilConditionMet setJob(Object job) {
        Goate work = this.definition.get("work", (Object)new Goate(), Goate.class);
        work.put("job", job);
        return this;
    }

    public WorkUntilConditionMet expect(Expectation expectation) {
        Goate expect = this.definition.get("expect", (Object)new Goate(), Goate.class);
        expect.put("" + expect.size(), expectation);
        return this;
    }

    public WorkUntilConditionMet expectTimeout(long timeoutMS) {
        this.definition.put("timeout_expect", timeoutMS);
        return this;
    }

    public WorkUntilConditionMet expectPeriod(long periodMS) {
        this.definition.put("period_expect", periodMS);
        return this;
    }

    @Override
    public WorkUntilConditionMet period(long periodMS) {
        super.period(periodMS);
        this.definition.put("period", this.period);
        return this;
    }

    public WorkUntilConditionMet timeout(long timeoutMS) {
        this.definition.put("timeout", timeoutMS);
        return this;
    }

    @Override
    public String[] detailedScrub() {
        return new String[]{"timeout", "work", "expect"};
    }

    public Employee init() {
        Goate actualJobDefinition = new ToGoate(this.definition.get("work", new Goate())).convert();
        this.timeout = Long.parseLong("" + this.definition.get("timeout", this.timeout));
        this.period = Long.parseLong("" + this.definition.get("period", this.period));
        this.actualJob = actualJobDefinition.get("job") instanceof Employee ? (Employee)actualJobDefinition.get("job") : WorkUntilConditionMet.recruit("" + actualJobDefinition.get("job"), actualJobDefinition, this.data);
        this.lastReturn = Boolean.parseBoolean("" + this.definition.get("return last", this.lastReturn));
        return this;
    }

    protected Object doWork() {
        Object result = null;
        boolean conditionsMet = false;
        if (this.actualJob != null) {
            Long startTime = System.currentTimeMillis();
            while (!conditionsMet && System.currentTimeMillis() - startTime < this.timeout) {
                result = this.actualJob.work();
                if (this.checkConditions(result)) {
                    conditionsMet = true;
                    continue;
                }
                try {
                    Thread.sleep(this.period);
                }
                catch (InterruptedException e) {
                    this.LOG.debug("Work Until Condition", "Problem sleeping: " + e.getMessage(), e);
                }
            }
        }
        if (!conditionsMet) {
            this.LOG.debug("Work Until Condition", "Last work result:\n" + result);
            if (!this.lastReturn) {
                result = null;
            }
        }
        return result;
    }

    private boolean checkConditions(Object check) {
        boolean met;
        Object conditions = this.definition.get("expect", null);
        boolean bl = met = conditions == null;
        if (!met) {
            met = this.evaluate(new ToGoate(conditions).convert().put("_goate_result", check));
            if (met) {
                this.LOG.debug("Work Until Condition", "Condition has been met, stopping execution");
            } else {
                this.LOG.debug("Work Until Condition", "Condition has not been met, execution will continue unless timedout:\n" + conditions.toString());
            }
        }
        return met;
    }

    protected boolean evaluate(Goate conditions) {
        ExpectationThreadBuilder etb = new ExpectationThreadBuilder(new Goate().put("parent", this.definition).merge(this.data, false).put("_goate_result", conditions.get("_goate_result")));
        etb.expect(conditions).timeout(Long.parseLong("" + this.definition.get("timeout_expect", 50L))).period(Long.parseLong("" + this.definition.get("period_expect", 50L)));
        ExpectEvaluator ev = new ExpectEvaluator(etb);
        return ev.evaluate();
    }
}

