/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.utils.file.Copy;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GoateUtils {
    static final BleatBox LOG = BleatFactory.getLogger(GoateUtils.class);

    public static Object getProperty(String key) {
        return GoateUtils.getProperty(key, null);
    }

    public static Object getProperty(String key, Object def) {
        return new Goate().get(key, def);
    }

    public static void sleep(long sleepInMillis) {
        GoateUtils.sleep(sleepInMillis, LOG);
    }

    public static void sleep(long sleepInMillis, BleatBox logger) {
        try {
            Thread.sleep(sleepInMillis);
        }
        catch (InterruptedException e) {
            logger.warn("Goate Sleep Util", "problem sleeping: " + e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public static String getFilePath(String file) {
        return GoateUtils.getFilePath(file, false, false);
    }

    public static boolean fileExists(String file) {
        return new File(GoateUtils.getFilePath(file)).exists();
    }

    public static String moveUpDir(String fileName) {
        while (fileName.contains("../")) {
            int upFolderIndex;
            String temp = fileName.substring(0, fileName.indexOf("../"));
            if (temp.endsWith("/")) {
                temp = temp.substring(0, temp.length() - 1);
            }
            if ((upFolderIndex = temp.lastIndexOf("/")) > 0) {
                temp = temp.substring(0, upFolderIndex);
            }
            fileName = temp + fileName.substring(fileName.indexOf("../") + 2);
        }
        return fileName;
    }

    public static String getFilePath(String fileName, boolean leaveInJar, boolean force) {
        if (fileName.indexOf("/") != 0 && fileName.indexOf("\\") != 0) {
            fileName = "/" + fileName;
        }
        fileName = GoateUtils.moveUpDir(fileName);
        String path = System.getProperty("user.dir") + fileName;
        LOG.debug("Goate File Util", "checking path: " + path);
        try {
            File temp = new File(path);
            if (!temp.exists()) {
                path = fileName;
                LOG.debug("Goate File Util", "file did not exist, checking resources: " + path);
                URL opath = GoateUtils.class.getResource(path);
                if (opath != null) {
                    path = GoateUtils.class.getResource(path).toString();
                } else {
                    LOG.debug("Goate File Util", "did not find the resource");
                }
                if (path.contains("jar:")) {
                    if (!leaveInJar) {
                        String tempPath;
                        File tf = new File("temp" + fileName);
                        path = force || !tf.exists() ? ((tempPath = new Copy().file(opath).to("temp" + fileName, force)) == null ? new File("temp" + path.substring(path.lastIndexOf("/"))).getAbsolutePath() : new File(tempPath).getAbsolutePath()) : tf.getAbsolutePath();
                    } else {
                        path = path.replace("jar:", "");
                    }
                }
                path = path.replace("file:/", "");
                if ((path = path.replace("file:", "")).indexOf(":") != 1) {
                    path = "/" + path;
                }
                if (path.contains(":") && path.indexOf("/") == 0) {
                    path = path.substring(1);
                }
                LOG.debug("Goate File Util", "modified path to look in: " + path);
                temp = new File(path);
            }
            path = temp.getAbsolutePath();
            LOG.debug("Goate File Util", "file path: " + path);
        }
        catch (Exception e) {
            LOG.debug("Goate File Util", "Exception encountered finding file: " + e.getMessage(), e);
        }
        if (path.contains("%")) {
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (Exception e) {
                LOG.info("Goate File Util", "Failed to decode a possibly url encoded path to UTF-8");
            }
        }
        return path;
    }

    /*
     * Exception decompiling
     */
    public static <K, V> void setEnvironment(String key, String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void removeEnvironment(String key) {
        GoateUtils.setEnvironment(key, null);
    }

    protected static List<Class> filterClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Class<?> c : Collections.class.getDeclaredClasses()) {
            if (!"java.util.Collections$UnmodifiableMap".equals(c.getName())) continue;
            classes.add(c);
        }
        return classes;
    }

    protected static List<Field> mapFields(List<Class> classes) throws NoSuchFieldException {
        ArrayList<Field> map = new ArrayList<Field>();
        for (Class c : classes) {
            map.add(c.getDeclaredField("m"));
        }
        return map;
    }

    public static String tab(int count) {
        StringBuilder tabs = new StringBuilder("");
        while (count > 0) {
            tabs.append("\t");
            --count;
        }
        return tabs.toString();
    }

    public static boolean truth(Object value) {
        return value == null ? false : Boolean.parseBoolean("" + value);
    }
}

