/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.cmd;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Consumer;

public class Command {
    BleatBox LOG = BleatFactory.getLogger(this.getClass());
    List<String> cmd = new ArrayList<String>();

    public Command(String command) {
        if (command != null && !command.isEmpty()) {
            this.cmd.add(command);
        }
    }

    public Command arg(String arg) {
        this.cmd.add(arg);
        return this;
    }

    public Goate execute() {
        String commandOutput = "";
        int exitCode = -42;
        if (this.cmd != null && this.cmd.size() > 0) {
            ProcessBuilder builder = new ProcessBuilder(this.cmd);
            try {
                Process process = builder.start();
                Trough bucket = new Trough();
                StreamGobbler streamGobbler = new StreamGobbler(process.getInputStream(), bucket::eat);
                Executors.newSingleThreadExecutor().submit(streamGobbler);
                exitCode = process.waitFor();
                commandOutput = bucket.getFeed();
            }
            catch (IOException | InterruptedException e) {
                this.LOG.error("command", "problem running command: " + e.getMessage(), e);
                commandOutput = e.getMessage();
            }
        } else {
            commandOutput = "no command defined";
        }
        return new Goate().put("exit code", exitCode).put("output", commandOutput);
    }

    private class Trough {
        StringBuilder feed = new StringBuilder();

        private Trough() {
        }

        String getFeed() {
            return this.feed.toString();
        }

        void eat(String food) {
            System.out.println(food);
            this.feed.append(food).append("\n");
        }
    }

    private static class StreamGobbler
    implements Runnable {
        private InputStream inputStream;
        private Consumer<String> consumer;

        public StreamGobbler(InputStream inputStream, Consumer<String> consumer) {
            this.inputStream = inputStream;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            new BufferedReader(new InputStreamReader(this.inputStream)).lines().forEach(this.consumer);
        }
    }
}

