/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.compare;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.utils.UnknownUtilType;
import com.thegoate.utils.UtilCache;
import com.thegoate.utils.compare.CompareTool;
import com.thegoate.utils.compare.CompareUtil;
import com.thegoate.utils.compare.CompareUtility;
import com.thegoate.utils.compare.tools.CompareObject;
import com.thegoate.utils.type.FindType;

@UtilCache(name="compare", useCache=true)
public class Compare
extends UnknownUtilType
implements CompareUtility {
    final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    CompareUtility tool = null;
    Object actual = null;
    Object operator = null;
    Object expected = null;
    boolean compareNumeric = false;
    boolean triedOnce = false;
    protected boolean triedExpected = false;

    public Compare(Object actual) {
        this.actual = actual;
    }

    public Compare triedOnce(boolean triedOnce) {
        this.triedOnce = triedOnce;
        return this;
    }

    public Compare alreadyTriedExpected(boolean triedExpected) {
        this.triedExpected = triedExpected;
        return this;
    }

    @Override
    public boolean isType(Object check) {
        return false;
    }

    @Override
    public Goate healthCheck() {
        return new Goate().merge(this.health, false).merge(this.tool != null ? this.tool.healthCheck() : new Goate(), false);
    }

    @Override
    public boolean checkType(Class tool, Class type) {
        CompareUtil tu = tool.getAnnotation(CompareUtil.class);
        return tu.type() != null ? tu.type() == type : type == null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate() {
        boolean result = false;
        try {
            if (this.lookupTool()) {
                result = this.tool.evaluate();
            }
            if (result) return result;
        }
        catch (Exception e) {
            this.LOG.debug("Compare", "Failed to compare: " + e.getMessage(), e);
        }
        return result;
    }

    protected boolean lookupTool() {
        Class etype;
        Object act = this.actual;
        Object exp = this.expected;
        Class type = new FindType().type(act);
        if (!(type != null && !this.triedOnce && type != String.class || ("" + this.operator).equalsIgnoreCase("isNull") || (etype = new FindType().type(exp)) == null || this.triedExpected)) {
            type = etype;
            this.triedExpected = true;
        }
        try {
            this.tool = (CompareUtility)this.buildUtil(this.actual, CompareUtil.class, this.actual, "" + this.operator, CompareUtil.class.getMethod("operator", new Class[0]), type);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        boolean result = true;
        if (this.tool == null) {
            result = false;
            this.health.put("Tool Not Found", "Could not find \"" + this.operator + "\" for: " + this.actual + ", of type: " + type.getName());
        } else if (this.compareNumeric && this.tool instanceof CompareObject) {
            result = false;
            this.health.put("Tool Not Found", "Expecting to compare a numeric, but did not find an implementation for the numeric type: \"" + this.operator + "\" for: " + this.actual.getClass());
        } else {
            this.LOG.debug("Compare", "Found comparator: " + this.tool.getClass());
            if (this.tool instanceof CompareTool) {
                ((CompareTool)this.tool).triedOnce(this.triedOnce).alreadyTriedExpected(this.triedExpected);
            }
            this.tool.actual(this.actual).to(this.expected).using(this.operator);
        }
        return result;
    }

    protected CompareUtility buildTool(Object checkFor) {
        return this.buildTool(checkFor, "isType");
    }

    protected CompareUtility buildTool(Object checkFor, String isType) {
        CompareUtility foundTool = null;
        try {
            foundTool = (CompareUtility)this.buildUtil(checkFor, CompareUtil.class, "" + this.operator, CompareUtil.class.getMethod("operator", new Class[0]), isType);
        }
        catch (NoSuchMethodException e) {
            this.LOG.error("Problem finding the compare utility: " + e.getMessage(), e);
        }
        return foundTool;
    }

    public CompareUtility getTool() {
        if (this.tool == null) {
            this.tool = this.buildTool(this.actual);
        }
        return this.tool;
    }

    @Override
    public CompareUtility actual(Object actual) {
        this.actual = actual;
        return this;
    }

    @Override
    public CompareUtility to(Object expected) {
        this.expected = expected;
        return this;
    }

    @Override
    public CompareUtility using(Object operator) {
        this.operator = operator;
        return this;
    }

    public Compare compareNumeric(boolean compareNumeric) {
        this.compareNumeric = compareNumeric;
        return this;
    }
}

