/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.compare;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.utils.compare.Compare;
import com.thegoate.utils.compare.CompareUtility;
import com.thegoate.utils.fill.serialize.GoateCastUtility;

public abstract class CompareTool
implements CompareUtility {
    protected final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    protected Object actual = null;
    protected Object expected = null;
    protected Object operator = null;
    protected boolean nested = false;
    protected Goate health = new Goate();
    protected Goate data;
    protected GoateCastUtility caster = null;
    protected boolean triedOnce = false;
    protected boolean triedExpected = false;

    public CompareTool(Object actual) {
        this.actual = actual;
    }

    public CompareTool nested() {
        this.nested = true;
        return this;
    }

    public boolean isNested() {
        return this.nested;
    }

    public CompareTool triedOnce(boolean triedOnce) {
        this.triedOnce = triedOnce;
        return this;
    }

    public CompareTool alreadyTriedExpected(boolean triedExpected) {
        this.triedExpected = triedExpected;
        return this;
    }

    protected boolean tryExpectedType(String op) {
        boolean result = false;
        if (!this.isNested() && !this.triedOnce) {
            Compare compare = new Compare(this.expected);
            compare.using(op).to(this.actual);
            CompareUtility cu = compare.getTool();
            if (cu instanceof CompareTool) {
                ((CompareTool)cu).nested();
            }
            result = compare.triedOnce(true).alreadyTriedExpected(this.triedExpected).actual(this.actual).to(this.expected).evaluate();
        }
        return result;
    }

    @Override
    public CompareTool setData(Goate data) {
        this.data = data;
        return this;
    }

    @Override
    public CompareUtility actual(Object actual) {
        this.actual = actual;
        return this;
    }

    @Override
    public CompareUtility to(Object expected) {
        this.expected = expected;
        return this;
    }

    @Override
    public CompareUtility using(Object operator) {
        this.operator = operator;
        return this;
    }

    @Override
    public Goate healthCheck() {
        return this.health;
    }
}

