/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.compare.tools;

import com.thegoate.HealthMonitor;
import com.thegoate.annotations.IsDefault;
import com.thegoate.logging.volume.VolumeKnob;
import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.compare.Compare;
import com.thegoate.utils.compare.CompareUtil;
import com.thegoate.utils.compare.tools.CompareObject;
import java.util.Objects;

@CompareUtil(operator="!=")
@IsDefault
public class CompareObjectNotEqualTo
extends CompareObject {
    public CompareObjectNotEqualTo(Object actual) {
        super(actual);
    }

    @Override
    public boolean isType(Object check) {
        return false;
    }

    @Override
    public boolean evaluate() {
        boolean result = false;
        GoateReflection gr = new GoateReflection();
        if (this.expected != null && (gr.isPrimitive(this.expected.getClass()) || this.expected instanceof Number)) {
            this.LOG.debug("isNotEqualTo", "Detected a primitive, will try to compare as that formatted primitive type.");
            Compare comp = new Compare(this.expected);
            result = comp.compareNumeric(this.expected instanceof Number).to(this.actual).using("!=").evaluate();
            this.health = comp.healthCheck();
        } else {
            boolean bl = result = !Objects.equals(this.actual, this.expected);
        }
        if (this.actual instanceof HealthMonitor) {
            this.health = ((HealthMonitor)this.actual).healthCheck();
        } else if (!result) {
            this.health.put("is equal", "" + VolumeKnob.volume(this.actual) + "==" + VolumeKnob.volume(this.expected));
        }
        return result;
    }
}

