/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.compare.tools.date;

import com.thegoate.annotations.IsDefault;
import com.thegoate.utils.compare.CompareTool;
import com.thegoate.utils.compare.CompareUtil;
import java.text.SimpleDateFormat;

@CompareUtil(operator="dateIsPattern", type=String.class)
@IsDefault
public class CompareDateStringIsPattern
extends CompareTool {
    public CompareDateStringIsPattern(Object actual) {
        super(actual);
    }

    @Override
    public boolean evaluate() {
        String pattern = "" + this.expected;
        String act = "" + this.actual;
        boolean result = true;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
            try {
                dateFormat.parse(act);
            }
            catch (Exception e) {
                result = false;
                this.health.put("incorrect pattern", act + " != " + pattern);
                this.LOG.debug("Date String is Pattern", "Date: " + act + " was not in the expected format: " + pattern + ". " + e.getMessage(), e);
            }
        }
        catch (Exception e) {
            result = false;
            this.health.put("invalid format", "'" + pattern + "' is not a valid date pattern");
            this.LOG.debug("Date String is Pattern", "'" + pattern + "' is not a valid date pattern: " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public boolean isType(Object check) {
        return true;
    }
}

