/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.compare.tools.f;

import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.ParseDetector;
import com.thegoate.utils.compare.CompareTool;
import com.thegoate.utils.compare.tools.d.CompareDoubleEqualTo;

public abstract class CompareFloatTool
extends CompareTool
implements ParseDetector {
    public CompareFloatTool(Object actual) {
        super(actual);
    }

    @Override
    public boolean isType(Object check) {
        boolean istype = false;
        try {
            GoateReflection gr = new GoateReflection();
            if (gr.isFloatType(check.getClass())) {
                this.LOG.debug("Check Type", "detected primitive float");
                istype = true;
            } else {
                this.LOG.debug("Check Type", "not a primitive float.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return istype;
    }

    @Override
    public boolean parseDetector(Object object) {
        boolean result = false;
        try {
            this.parseFloat(object);
            if (!new CompareDoubleEqualTo(this.actual).parseDetector(object)) {
                result = true;
            } else {
                this.LOG.debug("Parse Detector", "Detected a possible double, will treat it as such instead.");
            }
        }
        catch (Exception e) {
            this.LOG.debug("Parse Detector", "Not a parsable float.");
        }
        return result;
    }

    protected float parseFloat(Object o) {
        return new GoateReflection().parseFloat(o);
    }
}

