/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.file;

import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.utils.GoateUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Copy {
    private final BleatBox LOG = BleatFactory.getLogger(this.getClass());
    private String originalFile = null;
    private File file = null;
    private InputStream fileInputStream = null;

    public static Copy copy(File copy) {
        return new Copy(copy);
    }

    public Copy() {
    }

    public Copy(String originalFile) {
        this.file(originalFile);
    }

    public Copy(File file) {
        this.file(file);
    }

    public Copy(InputStream inputStream) {
        this.file(inputStream);
    }

    public Copy file(InputStream inputStream) {
        this.fileInputStream = inputStream;
        this.originalFile = null;
        this.file = null;
        return this;
    }

    public Copy file(String originalFile) {
        this.fileInputStream = null;
        this.file = null;
        this.originalFile = GoateUtils.getFilePath(originalFile);
        return this;
    }

    public Copy file(File file) {
        this.fileInputStream = null;
        this.originalFile = null;
        this.file = file;
        return this;
    }

    public Copy file(URL originalUrl) {
        try {
            this.file(originalUrl.openStream());
            this.originalFile = originalUrl.getPath();
        }
        catch (IOException e) {
            this.LOG.error("Problem opening a stream to the url: " + e.getMessage(), e);
        }
        return this;
    }

    public String to(String copyFile) {
        return this.to(copyFile, true);
    }

    public String toDir(String destinationDir) {
        return this.to(destinationDir + "/" + this.getSource().getName(), true);
    }

    protected File getSource() {
        File sourceFile = null;
        if (this.originalFile != null) {
            sourceFile = new File(this.originalFile);
        }
        if (this.file != null) {
            sourceFile = this.file;
        }
        if (this.fileInputStream != null) {
            this.LOG.debug("you gave me an input stream. Unless you gave me the url, I cannot determine the sourceFile.");
        }
        return sourceFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String to(String copyFile, boolean overwrite) {
        String status;
        block22: {
            File destFile;
            File sourceFile;
            block21: {
                sourceFile = this.getSource();
                destFile = new File(copyFile);
                status = destFile.getAbsolutePath();
                if (destFile.exists()) {
                    if (overwrite) {
                        try {
                            if (destFile.delete()) {
                                this.LOG.debug("File deleted");
                                break block21;
                            }
                            this.LOG.debug("File could not be deleted");
                            status = null;
                        }
                        catch (Exception e) {
                            this.LOG.error("Copy File", e);
                            status = null;
                        }
                    } else {
                        status = null;
                    }
                }
            }
            if (status != null) {
                try {
                    this.LOG.debug("file: " + destFile.getAbsolutePath());
                    if (destFile.getParentFile().mkdirs()) {
                        this.LOG.debug("directory did not exist, had to make it.");
                    }
                    if (destFile.createNewFile()) {
                        this.LOG.debug("File created");
                        InputStream source = null;
                        FileOutputStream destination = null;
                        try {
                            if (sourceFile != null) {
                                source = this.fileInputStream == null ? new FileInputStream(sourceFile) : this.fileInputStream;
                            } else if (this.fileInputStream != null) {
                                source = this.fileInputStream;
                            }
                            if (source != null) {
                                destination = new FileOutputStream(destFile);
                                byte[] buffer = new byte[4096];
                                int bytesRead = source.read(buffer);
                                while (bytesRead != -1) {
                                    destination.write(buffer, 0, bytesRead);
                                    bytesRead = source.read(buffer);
                                }
                            }
                            break block22;
                        }
                        finally {
                            if (source != null) {
                                source.close();
                            }
                            if (destination != null) {
                                destination.close();
                            }
                        }
                    }
                    this.LOG.debug("File not created");
                    status = null;
                }
                catch (Error | Exception e) {
                    this.LOG.error("Copy failed" + e.getMessage(), e);
                    status = null;
                }
            }
        }
        return status;
    }
}

