/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.fill.serialize;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.UnknownUtilType;
import com.thegoate.utils.fill.serialize.CastUtil;
import com.thegoate.utils.fill.serialize.CastUtility;
import com.thegoate.utils.fill.serialize.DeSerializer;
import com.thegoate.utils.fill.serialize.GoateCastUtility;
import com.thegoate.utils.fill.serialize.GoatePojo;
import com.thegoate.utils.fill.serialize.TypeT;
import com.thegoate.utils.fill.serialize.string.StringConverter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Cast
extends UnknownUtilType {
    private BleatBox LOGGER = BleatFactory.getLogger(this.getClass());
    private Object[] args = new Object[0];
    private Goate data;
    private Class dataSource;
    private Field field;
    private Object container;

    public Cast(Goate data, Class dataSource) {
        this.data = data;
        this.dataSource = dataSource;
    }

    public <T> T cast(Object value, Class<T> type) throws IllegalAccessException, InstantiationException {
        Object object = null;
        GoateReflection gr = new GoateReflection();
        if (gr.isPrimitive(type)) {
            object = this.buildFromCastUtil(type, value);
        } else {
            GoatePojo goatePojo = type.getAnnotation(GoatePojo.class);
            if (goatePojo != null) {
                if (goatePojo.forceCast()) {
                    object = this.buildFromCastUtil(type, value);
                } else {
                    DeSerializer serializer = new DeSerializer().data(this.data).from(this.dataSource);
                    object = serializer.build(type);
                }
            } else if (type.equals(String.class)) {
                object = value instanceof String ? value : (value == null ? null : new StringConverter().value(value).convert());
            } else {
                Constructor constructor = this.findConstructor(type, value);
                try {
                    if (constructor != null) {
                        object = constructor.newInstance(this.args);
                    }
                }
                catch (InvocationTargetException e) {
                    this.LOGGER.debug("Cast", "Failed to construct the object: " + e.getMessage(), e);
                }
                if (object == null) {
                    object = this.buildFromCastUtil(type, value);
                }
            }
        }
        return (T)object;
    }

    public Cast container(Object o) {
        this.container = o;
        return this;
    }

    public Cast field(Field field) {
        this.field = field;
        return this;
    }

    protected Class getType(Class type) {
        Class t = type;
        if (type == TypeT.class) {
            if (this.container instanceof TypeT) {
                try {
                    Method get_type = this.container.getClass().getMethod("goateType", Integer.TYPE);
                    type = (Class)get_type.invoke(this.container, 0);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    this.LOGGER.debug("problem detecting type T, will just assume it is the type: " + e.getMessage());
                }
            }
            this.LOGGER.debug("found a generic type: " + type);
        }
        return t;
    }

    protected Object buildFromCastUtil(Class type, Object value) {
        CastUtility caster = (CastUtility)this.buildUtil(this.getType(type), CastUtil.class, value);
        if (caster == null) {
            this.LOGGER.error("Cast", "Could not build: " + type.getName() + ". You may need to implement a CastUtility to support that object type.");
            throw new RuntimeException("Could not build: " + type.getName() + ". You may need to implement a CastUtility to support that object type.");
        }
        this.LOGGER.debug("Cast", "Cast utility found, building object.");
        caster.setData(this.data);
        if (caster instanceof GoateCastUtility) {
            ((GoateCastUtility)caster).setContainer(this.container);
        }
        return caster.dataSource(this.dataSource).field(this.field).cast(type);
    }

    protected Constructor findConstructor(Class type, Object value) {
        Object[] asString = new Object[]{"" + value};
        Object[] selfie = new Object[]{value};
        Object[] empty = new Object[]{};
        GoateReflection gr = new GoateReflection();
        this.args = empty;
        Constructor constructor = gr.findConstructor(type, empty);
        if (constructor == null) {
            this.args = selfie;
            constructor = gr.findConstructor(type, selfie);
            if (constructor == null) {
                this.args = asString;
                constructor = gr.findConstructor(type, asString);
            }
        }
        return constructor;
    }

    @Override
    public boolean checkType(Class tool, Class type) {
        return false;
    }
}

