/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.fill.serialize;

import com.thegoate.Goate;
import com.thegoate.logging.BleatBox;
import com.thegoate.logging.BleatFactory;
import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.fill.serialize.Cast;
import com.thegoate.utils.fill.serialize.Cereal;
import com.thegoate.utils.fill.serialize.DefaultSource;
import com.thegoate.utils.fill.serialize.Generic;
import com.thegoate.utils.fill.serialize.GoatePojo;
import com.thegoate.utils.fill.serialize.GoateSource;
import com.thegoate.utils.fill.serialize.TypeT;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DeSerializer
extends Cereal {
    private BleatBox LOG = BleatFactory.getLogger(this.getClass());
    private Goate data;
    private Class dataSource;
    private List<Class> genericType = new ArrayList<Class>();

    public <T> T build(Class<T> type) {
        Object o;
        block12: {
            o = null;
            try {
                o = this.buildInstance(type);
                if (this.data == null) {
                    this.LOG.debug("Build Pojo", "The data was null, the pojo will be initialized but empty (unless defaults are set)");
                    break block12;
                }
                if (this.dataSource == null) {
                    this.LOG.debug("Build Pojo", "The data source was not specified, defaulting to default");
                    this.dataSource = DefaultSource.class;
                }
                GoateReflection gr = new GoateReflection();
                Map<String, Field> fields = gr.findFields(type);
                for (Map.Entry<String, Field> field : fields.entrySet()) {
                    GoateSource gs = DeSerializer.findGoateSource(field.getValue(), this.dataSource);
                    String fieldKey = field.getKey();
                    boolean flatten = false;
                    if (gs != null) {
                        fieldKey = gs.key();
                        flatten = gs.flatten();
                    }
                    Goate value = fieldKey.isEmpty() ? this.data : this.data.get(fieldKey);
                    boolean acc = field.getValue().isAccessible();
                    field.getValue().setAccessible(true);
                    try {
                        if (value != null || this.data.filter(fieldKey + "\\.").size() > 0 || this.data.getStrict(fieldKey) != null || field.getValue().getType().getAnnotation(GoatePojo.class) != null) {
                            Goate d = new Goate().merge(this.data, false);
                            if (!flatten) {
                                d = this.data.filter(fieldKey.replace("##", "[0-9]*"));
                                if (!fieldKey.isEmpty()) {
                                    d = d.scrubKeys(fieldKey + "\\.");
                                }
                            } else {
                                d = this.data.filterStrict(fieldKey.replace("##", "[0-9]*"));
                            }
                            field.getValue().set(o, new Cast(d, this.dataSource).container(o).field(field.getValue()).cast(value, this.getType(field.getValue())));
                        }
                    }
                    catch (Exception e) {
                        this.LOG.error("Build Pojo", "Failed to set field: " + e.getMessage(), e);
                    }
                    field.getValue().setAccessible(acc);
                }
            }
            catch (IllegalAccessException | InstantiationException e) {
                this.LOG.error("Build Pojo", "Failed to build the pojo: " + e.getMessage(), e);
            }
        }
        return (T)o;
    }

    private Class getType(Field field) {
        Generic t;
        Class c = field.getType();
        if (c == Object.class && (t = field.getAnnotation(Generic.class)) != null) {
            int index = t.index();
            if (this.genericType.size() > index) {
                c = this.genericType.get(index);
            }
        }
        return c;
    }

    private Object buildInstance(Class type) throws IllegalAccessException, InstantiationException {
        if (type == null) {
            this.LOG.error("Build Pojo", "Can't build the pojo if you don't tell me what to build.");
            throw new RuntimeException("The pojo class was not specified.");
        }
        Object o = type.newInstance();
        if (o instanceof TypeT) {
            ((TypeT)o).setGoateType(this.genericType);
        }
        return o;
    }

    public DeSerializer data(Goate data) {
        this.data = data;
        return this;
    }

    public DeSerializer T(Class type) {
        return this.genericType(type);
    }

    public DeSerializer genericType(Class type) {
        this.genericType.add(type);
        return this;
    }

    public DeSerializer data(Map<String, ?> data) {
        return this.data(new Goate(data));
    }

    public DeSerializer from(Class dataSource) {
        this.dataSource = dataSource;
        return this;
    }
}

