/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.fill.serialize;

import com.thegoate.Goate;
import com.thegoate.HealthMonitor;
import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.compare.Compare;
import com.thegoate.utils.compare.CompareUtility;
import com.thegoate.utils.fill.serialize.GoateIgnore;
import com.thegoate.utils.fill.serialize.TypeT;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class Nanny
implements HealthMonitor,
TypeT {
    @GoateIgnore
    protected String equalityCheck = "==";
    @GoateIgnore
    private List<Class> goateType = new ArrayList<Class>();
    @GoateIgnore
    private Goate health = new Goate();

    @Override
    public void setGoateType(List<Class> type) {
        this.goateType = type;
    }

    public Nanny equalityCheck(String check) {
        this.equalityCheck = check;
        return this;
    }

    @Override
    public Class goateType(int index) {
        Class c = Object.class;
        if (index < this.goateType.size()) {
            c = this.goateType.get(index);
        }
        return c;
    }

    protected void resetHealth() {
        this.health = new Goate();
    }

    public void reportHealth(String id, Object message) {
        this.health.put(id, message);
    }

    @Override
    public Goate healthCheck() {
        Goate report = this.health;
        this.resetHealth();
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object compare) {
        boolean result = true;
        if (compare == null) {
            result = false;
            this.reportHealth(this.getClass().getSimpleName(), "{ initialized instance != null }");
        }
        if (this.getClass().isInstance(compare)) {
            GoateReflection gr = new GoateReflection();
            for (Map.Entry<String, Field> field : gr.findFields(this.getClass()).entrySet()) {
                boolean accessible = field.getValue().isAccessible();
                try {
                    Object expected;
                    field.getValue().setAccessible(true);
                    Object actual = field.getValue().get(this);
                    CompareUtility check = new Compare(actual).to(expected = field.getValue().get(compare)).using(this.equalityCheck);
                    if (check.evaluate()) continue;
                    result = false;
                    String checkHealth = check.healthCheck().toString("\t\t", "", true);
                    String label = actual.getClass().getSimpleName() + " " + field.getKey();
                    if (checkHealth.isEmpty()) {
                        this.reportHealth(label, " {" + actual + " != " + expected + "}");
                        continue;
                    }
                    checkHealth = check.healthCheck().pad(checkHealth + "\n\t}", "\t");
                    this.reportHealth(label, " {\n" + checkHealth);
                }
                catch (Exception e) {
                    this.reportHealth("field access ##", "problem accessing field: " + e.getMessage());
                }
                finally {
                    field.getValue().setAccessible(accessible);
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(":{");
        GoateReflection gr = new GoateReflection();
        boolean notFirst = false;
        for (Map.Entry<String, Field> field : gr.findFields(this.getClass()).entrySet()) {
            if (notFirst) {
                sb.append(", ");
            }
            sb.append(field.getKey()).append(":");
            boolean accessible = field.getValue().isAccessible();
            Object fieldValue = "Exception: could not get toString";
            try {
                field.getValue().setAccessible(true);
                fieldValue = field.getValue().get(this);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            sb.append(fieldValue);
            notFirst = true;
        }
        sb.append("}");
        return sb.toString();
    }
}

