/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.fill.serialize;

import com.thegoate.Goate;
import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.fill.serialize.Cereal;
import com.thegoate.utils.fill.serialize.GoatePojo;
import com.thegoate.utils.fill.serialize.GoateSource;
import com.thegoate.utils.fill.serialize.to.SerializeTo;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Serializer<T, S, U>
extends Cereal {
    private T pojo;
    private S source;
    private U cereal;
    private boolean serializeNested = true;
    private boolean alwaysSerializeGoatePojo = false;

    public Serializer(T pojo, S source, U cereal) {
        this.pojo = pojo;
        this.source = source;
        this.cereal = cereal;
    }

    public Serializer(T pojo, S source) {
        this.pojo = pojo;
        this.source = source;
    }

    public void setPojo(T pojo) {
        this.pojo = pojo;
    }

    public T getPojo() {
        return this.pojo;
    }

    public void setSource(S source) {
        this.source = source;
    }

    public S getSource() {
        return this.source;
    }

    public Serializer doSerializeNested() {
        this.serializeNested = true;
        return this;
    }

    public Serializer skipSerializingObjects() {
        this.serializeNested = false;
        return this;
    }

    public Serializer alwaysSerializeGoatePojos() {
        this.alwaysSerializeGoatePojo = true;
        return this;
    }

    public Serializer skipSerializingGoatePojos() {
        this.alwaysSerializeGoatePojo = false;
        return this;
    }

    public Goate toGoate() {
        Goate data = new Goate();
        for (Map.Entry<String, Object> entry : this.toMap(HashMap.class).entrySet()) {
            data.put(entry.getKey(), entry.getValue());
        }
        return data;
    }

    public U to(SerializeTo serializer) {
        return (U)serializer.source((Class)this.source).cereal(this.pojo.getClass()).serialize(this.pojo);
    }

    public Map<String, Object> toMap(Class mapType) {
        Map data = null;
        try {
            data = (Map)mapType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            this.LOG.error("Serialze Pojo", "The mapType could not be initialized: " + e.getMessage(), e);
        }
        catch (ClassCastException e) {
            this.LOG.error("Serialze Pojo", "The mapType was not a valid map type: " + e.getMessage(), e);
        }
        if (data != null) {
            GoateReflection gr = new GoateReflection();
            Map<String, Field> fields = gr.findFields(this.pojo.getClass());
            try {
                for (Map.Entry<String, Field> field : fields.entrySet()) {
                    GoateSource gs = Serializer.findGoateSource(field.getValue(), (Class)this.source);
                    String fieldKey = field.getKey();
                    if (gs != null) {
                        fieldKey = gs.key();
                    }
                    boolean acc = field.getValue().isAccessible();
                    field.getValue().setAccessible(true);
                    try {
                        Object o = field.getValue().get(this.pojo);
                        if (gs != null && gs.serializeTo() != GoateSource.class) {
                            o = this.doCast(o, gs.serializeTo());
                        }
                        if (o != null) {
                            Class<?> type = field.getValue().getType();
                            if (!Modifier.isStatic(field.getValue().getModifiers())) {
                                if (this.checkNotPrimitive(type) && this.doSerialize(this.pojo.getClass())) {
                                    if (!type.equals(this.pojo.getClass())) {
                                        this.addMap(data, o, fieldKey);
                                    }
                                } else {
                                    data.put(fieldKey, o);
                                }
                            }
                        }
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        this.LOG.error("Serialize Pojo", "Failed to get field: " + e.getMessage(), e);
                    }
                    field.getValue().setAccessible(acc);
                }
            }
            catch (ClassCastException e) {
                this.LOG.error("Serialze Pojo", "The source, second constructor parameter, must be a Class (ie Something.class)");
            }
        }
        return data;
    }

    private boolean doSerialize(Class pojoType) {
        boolean serialize = true;
        if (!this.serializeNested) {
            if (this.alwaysSerializeGoatePojo) {
                if (pojoType.getAnnotation(GoatePojo.class) == null) {
                    serialize = false;
                }
            } else {
                serialize = false;
            }
        }
        return serialize;
    }

    private void addMap(Map<String, Object> data, Object o, String baseKey) {
        if (o instanceof List) {
            data.put(baseKey, o);
            for (int i = 0; i < ((List)o).size(); ++i) {
                Object io = ((List)o).get(i);
                this.process(data, io, baseKey + "." + i);
            }
        } else if (o.getClass().isArray()) {
            data.put(baseKey, o);
            for (int i = 0; i < Array.getLength(o); ++i) {
                Object io = Array.get(o, i);
                this.process(data, io, baseKey + "." + i);
            }
        } else if (o instanceof Map) {
            int i = 0;
            data.put(baseKey, o);
            for (Object keyValue : ((Map)o).keySet()) {
                Object io = ((Map)o).get(keyValue);
                this.process(data, io, baseKey + "." + i + ".value");
                data.put(baseKey + "." + i + ".key", keyValue);
                data.put(baseKey + "." + i + ".class", io.getClass().getName());
            }
        } else {
            Map<String, Object> innerD = new Serializer<Object, S, U>(o, this.source).toMap(HashMap.class);
            data.put(baseKey, innerD);
            for (Map.Entry<String, Object> entry : innerD.entrySet()) {
                data.put(baseKey + "." + entry.getKey(), entry.getValue());
            }
        }
    }

    private void process(Map<String, Object> data, Object io, String baseKey) {
        Class<?> type = io.getClass();
        if (this.checkNotPrimitive(type)) {
            this.addMap(data, io, baseKey);
        } else {
            data.put(baseKey, io);
        }
    }
}

