/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.fill.serialize.dsl;

import com.thegoate.Goate;
import com.thegoate.annotations.AnnotationFactory;
import com.thegoate.annotations.GoateDescription;
import com.thegoate.dsl.DSL;
import com.thegoate.dsl.GoateDSL;
import com.thegoate.reflection.GoateReflection;
import com.thegoate.utils.fill.serialize.DeSerializer;
import com.thegoate.utils.fill.serialize.GoatePojo;
import com.thegoate.utils.fill.serialize.GoateSourceDef;

@GoateDSL(word="goatePojo")
@GoateDescription(description="Builds the given pojo from the data from the specified source.", parameters={"the id of the pojo to be built, must be annotated with GoatePojo", "the id of the source the data comes from,(an empty object annotated with GoateSourceDef used in GoateSource annotation [source] on fields in the pojo), this parameter is optional, but recommended."})
public class GoatePojoDSL
extends DSL {
    Goate fieldValues = new Goate();

    public GoatePojoDSL(Object value) {
        super(value);
    }

    public static GoatePojoDSL goatePojo(Class theClass) {
        return GoatePojoDSL.goatePojo(theClass.getName(), (String)null);
    }

    public static GoatePojoDSL goatePojo(Class theClass, Class source) {
        return GoatePojoDSL.goatePojo(theClass.getName(), source.getName());
    }

    public static GoatePojoDSL goatePojo(Class theClass, String source) {
        return GoatePojoDSL.goatePojo(theClass.getName(), source);
    }

    public static GoatePojoDSL goatePojo(String id) {
        return GoatePojoDSL.goatePojo(id, (String)null);
    }

    public static GoatePojoDSL goatePojo(String id, Class source) {
        return GoatePojoDSL.goatePojo(id, source.getName());
    }

    public static GoatePojoDSL goatePojo(String id, String source) {
        return new GoatePojoDSL("pojo::" + id + (source == null || source.isEmpty() ? "" : "," + source));
    }

    public GoatePojoDSL setField(String field, Object value) {
        this.fieldValues.put(field, value);
        return this;
    }

    public Object build() {
        return this.build(new Goate());
    }

    public Object build(Goate data) {
        return this.evaluate(data);
    }

    @Override
    public Object evaluate(Goate data) {
        this.fieldValues.merge(data, false);
        Class pojo = this.find("" + this.get(1, this.fieldValues), GoatePojo.class);
        DeSerializer deSerializer = new DeSerializer();
        deSerializer.data(this.fieldValues);
        Object so = this.get(2, this.fieldValues);
        if (so != null) {
            deSerializer.from(this.find("" + so, GoateSourceDef.class));
        }
        if (pojo == null) {
            this.LOG.debug("Pojo DSL", "Failed to find the pojo: " + this.get(1, this.fieldValues) + ". Make sure the id is correct.");
        }
        return pojo != null ? deSerializer.build(pojo) : null;
    }

    protected Class find(String id, Class annotationType) {
        Class found = null;
        try {
            AnnotationFactory af = new AnnotationFactory().using(annotationType.getMethod("id", new Class[0])).doDefault().annotatedWith(annotationType).buildDirectory();
            found = af.find(id).lookUp();
        }
        catch (NoSuchMethodException e) {
            this.LOG.debug("Pojo DSL", "Problem looking up class: " + e.getMessage(), e);
        }
        if (found == null) {
            found = new GoateReflection().findClass(id);
        }
        if (found == null) {
            this.LOG.error("Pojo DSL", "Could not find the class: " + id);
        }
        return found;
    }
}

