/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.get;

import com.thegoate.utils.GoateUtils;
import com.thegoate.utils.get.GetTool;
import com.thegoate.utils.get.GetUtil;
import com.thegoate.utils.type.IsType;
import com.thegoate.utils.type.TypeUtility;
import java.io.File;
import java.nio.file.Paths;

@IsType
@GetUtil(type=GetFile.class)
public class GetFile
extends GetTool
implements TypeUtility {
    boolean explode = false;
    boolean overwrite = false;

    public GetFile() {
        super("fileIO::");
    }

    public GetFile(Object selector) {
        super(selector);
    }

    @Override
    public boolean isType(Object check) {
        return ("" + check).equalsIgnoreCase("fileIO::");
    }

    public GetFile explode() {
        this.explode = true;
        return this;
    }

    public GetFile overwrite() {
        this.overwrite = true;
        return this;
    }

    @Override
    public Object from(Object container) {
        File result = null;
        String file = "" + this.selector;
        if (!file.equals("") && !file.equalsIgnoreCase("null")) {
            String fullPath = GoateUtils.getFilePath(file, !this.explode, this.overwrite);
            try {
                if (fullPath.contains(":") && fullPath.indexOf("/") == 0) {
                    fullPath = fullPath.substring(1);
                }
                result = new File(Paths.get(fullPath, new String[0]).toUri());
            }
            catch (Exception e) {
                this.LOG.error("Problem loading file into a string: " + e.getMessage(), e);
            }
        }
        return result;
    }

    @Override
    public Class type(Object check) {
        return this.getClass();
    }
}

