/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.get;

import com.thegoate.utils.GoateUtils;
import com.thegoate.utils.get.GetTool;
import com.thegoate.utils.get.GetUtil;
import com.thegoate.utils.get.NotFound;
import com.thegoate.utils.type.IsType;
import com.thegoate.utils.type.TypeUtility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;

@IsType
@GetUtil(type=GetFileAsString.class)
public class GetFileAsString
extends GetTool
implements TypeUtility {
    boolean explode = false;
    boolean overwrite = false;

    public GetFileAsString() {
        super("file::");
    }

    public GetFileAsString(Object selector) {
        super(selector);
    }

    @Override
    public boolean isType(Object check) {
        return ("" + check).equalsIgnoreCase("file::");
    }

    public GetFileAsString explode() {
        this.explode = true;
        return this;
    }

    public GetFileAsString overwrite() {
        this.overwrite = true;
        return this;
    }

    @Override
    public Object from(Object container) {
        Object result = new NotFound("" + this.selector);
        if (this.selector instanceof File) {
            try {
                result = new String(Files.readAllBytes(((File)this.selector).toPath()));
            }
            catch (IOException e) {
                this.LOG.error("Problem loading file into a string: " + e.getMessage(), e);
            }
        } else {
            String file = "" + this.selector;
            if (!file.equals("") && !file.equalsIgnoreCase("null")) {
                String fullPath = GoateUtils.getFilePath(file, !this.explode, this.overwrite);
                try {
                    if (fullPath.contains(":") && fullPath.indexOf("/") == 0) {
                        fullPath = fullPath.substring(1);
                    }
                    result = new String(Files.readAllBytes(Paths.get(fullPath, new String[0])));
                }
                catch (Exception e) {
                    this.LOG.error("Problem loading file into a string: " + e.getMessage(), e);
                }
            }
        }
        result = this.processNested(result);
        return result;
    }

    @Override
    public Class type(Object check) {
        return this.getClass();
    }
}

