/*
 * Decompiled with CFR 0.152.
 */
package com.thegoate.utils.get;

import com.thegoate.utils.GoateUtils;
import com.thegoate.utils.get.GetTool;
import com.thegoate.utils.get.GetUtil;
import com.thegoate.utils.type.IsType;
import com.thegoate.utils.type.TypeUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@IsType
@GetUtil(type=GetFileListFromDir.class)
public class GetFileListFromDir
extends GetTool
implements TypeUtility {
    List<File> files = new ArrayList<File>();

    public GetFileListFromDir() {
        super("filedir::");
    }

    public GetFileListFromDir(Object selector) {
        super(selector);
    }

    @Override
    public boolean isType(Object check) {
        return ("" + check).equalsIgnoreCase("filedir::");
    }

    @Override
    public Object from(Object container) {
        File original = null;
        if (this.selector instanceof File) {
            if (((File)this.selector).isDirectory()) {
                original = (File)this.selector;
                for (File f : original.listFiles()) {
                    this.selector = f;
                    this.from(container);
                }
                this.selector = original;
            } else if (((File)this.selector).exists()) {
                this.files.add((File)this.selector);
            }
        } else {
            String file = "" + this.selector;
            if (!file.equals("") && !file.equalsIgnoreCase("null")) {
                String fullPath = GoateUtils.getFilePath(file);
                try {
                    if (fullPath.contains(":") && fullPath.indexOf("/") == 0) {
                        fullPath = fullPath.substring(1);
                    }
                    this.selector = new File(fullPath);
                    if (((File)this.selector).isDirectory()) {
                        original = (File)this.selector;
                        for (File f : original.listFiles()) {
                            this.selector = f;
                            this.from(container);
                        }
                        this.selector = original;
                    } else if (((File)this.selector).exists()) {
                        this.files.add((File)this.selector);
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Problem loading file into a string: " + e.getMessage(), e);
                }
            }
        }
        Object result = this.processNested(this.files);
        return result;
    }

    @Override
    public Class type(Object check) {
        return this.getClass();
    }
}

